/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.activities;

import java.rmi.activation.ActivationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.activities.AbstractActivity;
import net.aufdemrand.denizen.activities.core.TaskActivity;
import net.aufdemrand.denizen.activities.core.WanderActivity;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ActivityRegistry {
    private Map<String, AbstractActivity> activities = new HashMap<String, AbstractActivity>();
    private Map<Class<? extends AbstractActivity>, String> activitiesClass = new HashMap<Class<? extends AbstractActivity>, String>();
    public Denizen plugin;

    public ActivityRegistry(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean registerActivity(String activityName, AbstractActivity activityClass) {
        this.activities.put(activityName.toUpperCase(), activityClass);
        this.activitiesClass.put(activityClass.getClass(), activityName.toUpperCase());
        activityClass.activityName = activityName.substring(0, 1).toUpperCase() + activityName.substring(1).toLowerCase();
        this.plugin.getLogger().log(Level.INFO, "Loaded " + activityClass.activityName + " Activity successfully!");
        return true;
    }

    public Map<String, AbstractActivity> listActivities() {
        if (this.plugin.debugMode.booleanValue()) {
            this.plugin.getLogger().log(Level.INFO, "Contents of ActivityList: " + this.activities.keySet().toString());
        }
        return this.activities;
    }

    public AbstractActivity getActivity(String activityName) {
        if (this.activities.containsKey(activityName.toUpperCase())) {
            return this.activities.get(activityName.toUpperCase());
        }
        return null;
    }

    public <T extends AbstractActivity> T getActivity(Class<T> theClass) {
        if (this.activitiesClass.containsKey(theClass)) {
            return (T)((AbstractActivity)theClass.cast(this.activities.get(this.activitiesClass.get(theClass))));
        }
        return null;
    }

    public void registerCoreActivities() {
        WanderActivity wanderActivity = new WanderActivity();
        TaskActivity taskActivity = new TaskActivity();
        try {
            wanderActivity.activateAs("WANDER");
            taskActivity.activateAs("TASK");
        }
        catch (ActivationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Oh no! Denizen has run into a problem registering the core triggers!");
            e.printStackTrace();
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)wanderActivity, (Plugin)this.plugin);
    }

    public void addActivity(String activity, DenizenNPC theDenizen, String[] args, int priority) {
        if (this.activities.containsKey(activity.toUpperCase())) {
            this.activities.get(activity.toUpperCase()).addGoal(theDenizen, args, priority);
        } else {
            this.plugin.getLogger().log(Level.SEVERE, "'" + activity + "' is an invalid activity!");
        }
    }

    public void removeActivity(String activity, NPC theDenizen) {
        if (this.activities.containsKey(activity.toUpperCase())) {
            this.activities.get(activity.toUpperCase()).removeGoal(this.plugin.getDenizenNPCRegistry().getDenizen(theDenizen), true);
        } else {
            this.plugin.getLogger().log(Level.SEVERE, "Invalid activity!");
        }
    }

    public void removeAllActivities(NPC theDenizen) {
        for (AbstractActivity theActivity : this.activities.values()) {
            theActivity.removeGoal(this.plugin.getDenizenNPCRegistry().getDenizen(theDenizen), false);
        }
    }
}

