/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.activities.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.activities.AbstractActivity;
import net.aufdemrand.denizen.activities.core.TaskGoal;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.citizensnpcs.api.ai.Goal;

public class TaskActivity
extends AbstractActivity {
    private Map<Integer, List<TaskGoal>> taskMap = new HashMap<Integer, List<TaskGoal>>();

    @Override
    public void addGoal(DenizenNPC npc, String[] arguments, int priority) {
        this.aH.echoDebug("Adding TASK Activity.");
        int delay = 60;
        int repeats = -1;
        String script = null;
        int duration = 50;
        for (String thisArgument : arguments) {
            if (thisArgument.toUpperCase().contains("DELAY:")) {
                try {
                    delay = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("REPEATS:")) {
                try {
                    repeats = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("DURATION:")) {
                try {
                    duration = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (!thisArgument.toUpperCase().contains("SCRIPT:")) continue;
            script = this.aH.getStringModifier(thisArgument);
        }
        List<TaskGoal> taskGoals = new ArrayList<TaskGoal>();
        if (this.taskMap.containsKey(npc.getId())) {
            this.aH.echoDebug("Has TASK activity already, size now: " + this.taskMap.get(npc.getId()).size());
            taskGoals = this.taskMap.get(npc.getId());
        }
        taskGoals.add(0, new TaskGoal(npc, delay, duration, script, repeats, this));
        this.aH.echoDebug("Added activity, size now: " + this.taskMap.size());
        this.taskMap.put(npc.getId(), taskGoals);
        npc.getCitizensEntity().getDefaultGoalController().addGoal((Goal)this.taskMap.get(npc.getId()).get(0), priority);
        this.aH.echoDebug("Goal Controller: " + this.taskMap.size());
    }

    @Override
    public void removeGoal(DenizenNPC npc, boolean verbose) {
        if (this.taskMap.containsKey(npc.getId())) {
            for (TaskGoal goal : this.taskMap.get(npc.getId())) {
                npc.getCitizensEntity().getDefaultGoalController().removeGoal((Goal)goal);
            }
            this.taskMap.remove(npc.getId());
            if (verbose) {
                this.plugin.getLogger().info("Removed Wander Activity from NPC.");
            }
        } else if (verbose) {
            this.plugin.getLogger().info("NPC does not have this activity...");
        }
    }
}

