/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.activities.core;

import java.util.List;
import net.aufdemrand.denizen.activities.core.TaskActivity;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;

public class TaskGoal
implements Goal {
    DenizenNPC denizenNPC;
    TaskActivity tA;
    final int delay;
    final int duration;
    final int repeats;
    final String scriptName;
    int counter;
    private long cooldownMap = 0L;
    private long durationMap = 0L;

    public TaskGoal(DenizenNPC npc, int delay, int duration, String scriptName, int repeats, TaskActivity taskActivity) {
        this.tA = taskActivity;
        this.denizenNPC = npc;
        this.delay = delay;
        this.duration = duration;
        this.repeats = repeats;
        this.counter = 0;
        this.scriptName = scriptName;
    }

    public void reset() {
    }

    public void run(GoalSelector goalSelecter) {
        if (this.hasDuration()) {
            if (this.getDurationTimeout() < System.currentTimeMillis()) {
                ++this.counter;
                this.cooldown();
                this.removeDuration();
                goalSelecter.finish();
            }
        } else {
            this.setDuration();
            ScriptHelper sE = this.tA.plugin.getScriptEngine().helper;
            List<String> theScript = sE.getScript(this.scriptName + ".Script");
            if (theScript.isEmpty()) {
                return;
            }
            sE.queueScriptEntries(this.denizenNPC, sE.buildScriptEntries(this.denizenNPC, theScript, this.scriptName), ScriptEngine.QueueType.ACTIVITY);
        }
    }

    public boolean shouldExecute(GoalSelector arg0) {
        if (this.counter <= this.repeats || this.repeats == -1) {
            return this.isCool();
        }
        return false;
    }

    public void cooldown() {
        this.tA.aH.echoDebug("Cooldown.");
        this.cooldownMap = System.currentTimeMillis() + (long)(this.delay * 1000);
    }

    public boolean isCool() {
        return this.cooldownMap < System.currentTimeMillis();
    }

    public void setDuration() {
        this.durationMap = System.currentTimeMillis() + (long)(this.duration * 1000);
    }

    public void removeDuration() {
        this.durationMap = 0L;
    }

    public boolean hasDuration() {
        return this.durationMap != 0L;
    }

    public long getDurationTimeout() {
        return this.durationMap;
    }
}

