/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.activities.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizen.activities.AbstractActivity;
import net.aufdemrand.denizen.activities.core.WanderGoal;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WanderActivity
extends AbstractActivity
implements Listener {
    private Map<NPC, WanderGoal> wanderMap = new HashMap<NPC, WanderGoal>();

    @Override
    public void addGoal(DenizenNPC npc, String[] arguments, int priority) {
        this.aH.echoDebug("Adding WANDER Activity for " + npc.getName() + "/" + npc.getId());
        int delay = 10;
        int radius = 5;
        int depth = 2;
        float speed = npc.getNavigator().getDefaultParameters().speed();
        Location specifiedLocation = null;
        ArrayList<Material> materialList = new ArrayList<Material>();
        ArrayList<Integer> materialIdList = new ArrayList<Integer>();
        npc.getNavigator().getDefaultParameters().avoidWater(true);
        for (String thisArgument : arguments) {
            if (thisArgument.toUpperCase().contains("DELAY:")) {
                try {
                    delay = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("RADIUS:")) {
                try {
                    radius = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("DEPTH:")) {
                try {
                    depth = Integer.valueOf(thisArgument.split(":", 2)[1]);
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("SPEED:")) {
                try {
                    speed = Float.valueOf(thisArgument.split(":", 2)[1]).floatValue();
                }
                catch (NumberFormatException e) {
                    this.aH.echoError("...bad argument '%s'!", thisArgument);
                }
                continue;
            }
            if (thisArgument.toUpperCase().contains("FILTER:")) {
                for (String materialString : thisArgument.split(":")[1].split(",")) {
                    try {
                        if (materialString.matches("//d+")) {
                            materialIdList.add(Integer.valueOf(materialString));
                            continue;
                        }
                        materialList.add(Material.valueOf((String)materialString.toUpperCase().trim()));
                    }
                    catch (Exception e) {
                        this.aH.echoError("...bad argument '%s'! Check to be sure this is a valid Material.", thisArgument);
                    }
                }
                continue;
            }
            if (!this.aH.matchesBookmark(thisArgument)) continue;
            if (this.aH.getBookmarkModifier(thisArgument, npc) != null) {
                specifiedLocation = this.aH.getBookmarkModifier(thisArgument, npc);
            }
            this.aH.echoDebug("...will wander '%s'.", thisArgument);
        }
        if (this.wanderMap.containsKey(npc)) {
            this.aH.echoDebug("Already found a WANDER instance for this NPC! Removing first...");
            this.removeGoal(npc, true);
        }
        this.wanderMap.put(npc.getCitizensEntity(), new WanderGoal(npc, radius, depth, delay, speed, materialList, materialIdList, specifiedLocation, this));
        npc.getCitizensEntity().getDefaultGoalController().addGoal((Goal)this.wanderMap.get(npc.getCitizensEntity()), priority);
    }

    @Override
    public void removeGoal(DenizenNPC npc, boolean verbose) {
        if (this.wanderMap.containsKey(npc.getCitizensEntity())) {
            npc.getCitizensEntity().getDefaultGoalController().removeGoal((Goal)this.wanderMap.get(npc.getCitizensEntity()));
            this.wanderMap.remove(npc.getCitizensEntity());
            if (verbose) {
                this.plugin.getLogger().info("Removed Wander Activities from NPC.");
            }
        } else if (verbose) {
            this.plugin.getLogger().info("NPC does not have this activity...");
        }
    }

    public Location getNewLocation(double X, double Y, double Z, World world, int radius, int depth) {
        Location newLocation = new Location(world, X, Y, Z);
        Random intRandom = new Random();
        int randomX = intRandom.nextInt(radius * 2) - radius;
        int randomZ = intRandom.nextInt(radius * 2) - radius;
        int randomY = 0;
        randomY = depth > 1 ? intRandom.nextInt(depth * 2) - depth : 2;
        newLocation.setX(newLocation.getX() + (double)randomX);
        newLocation.setZ(newLocation.getZ() + (double)randomZ);
        newLocation.setY(newLocation.getY() + (double)randomY);
        return newLocation;
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        if (this.wanderMap.containsKey(event.getNPC())) {
            this.wanderMap.get(event.getNPC()).cooldown();
        }
    }
}

