/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.bookmarks;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BookmarkHelper {
    private Denizen plugin;
    private Map<Location, String> locationTriggerList = new ConcurrentHashMap<Location, String>();

    public BookmarkHelper(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean checkLocation(Player thePlayer, Location theLocation, int theLeeway) {
        if (Math.abs(thePlayer.getLocation().getBlockX() - theLocation.getBlockX()) > theLeeway) {
            return false;
        }
        if (Math.abs(thePlayer.getLocation().getBlockY() - theLocation.getBlockY()) > theLeeway) {
            return false;
        }
        if (Math.abs(thePlayer.getLocation().getBlockZ() - theLocation.getBlockZ()) > theLeeway) {
            return false;
        }
        return thePlayer.getWorld().getName().equals(theLocation.getWorld().getName());
    }

    public boolean checkLocation(NPC theDenizen, Location theLocation, int theLeeway) {
        if (Math.abs(theDenizen.getBukkitEntity().getLocation().getBlockX() - theLocation.getBlockX()) > theLeeway) {
            return false;
        }
        if (Math.abs(theDenizen.getBukkitEntity().getLocation().getBlockY() - theLocation.getBlockY()) > theLeeway) {
            return false;
        }
        if (Math.abs(theDenizen.getBukkitEntity().getLocation().getBlockZ() - theLocation.getBlockZ()) > theLeeway) {
            return false;
        }
        return theDenizen.getBukkitEntity().getWorld().getName().equals(theLocation.getWorld().getName());
    }

    public void buildLocationTriggerList() {
        String theInfo;
        Location theLocation;
        List locationsToAdd;
        this.locationTriggerList.clear();
        for (DenizenNPC theDenizen : this.plugin.getDenizenNPCRegistry().getDenizens().values()) {
            if (!this.plugin.getSaves().contains("Denizens." + theDenizen.getName() + ".Bookmarks.Location")) continue;
            locationsToAdd = this.plugin.getSaves().getStringList("Denizens." + theDenizen.getName() + ".Bookmarks.Location");
            for (String thisLocation : locationsToAdd) {
                if (thisLocation.isEmpty()) continue;
                theLocation = this.get(theDenizen.getName(), thisLocation.split(" ", 2)[0], BookmarkType.LOCATION);
                theInfo = "NAME:" + theDenizen.getName() + ":" + thisLocation.split(" ", 2)[0];
                this.locationTriggerList.put(theLocation, theInfo);
            }
        }
        for (DenizenNPC theDenizen : this.plugin.getDenizenNPCRegistry().getDenizens().values()) {
            if (!this.plugin.getSaves().contains("Denizens." + theDenizen.getId() + ".Bookmarks.Location")) continue;
            locationsToAdd = this.plugin.getSaves().getStringList("Denizens." + theDenizen.getId() + ".Bookmarks.Location");
            for (String thisLocation : locationsToAdd) {
                if (thisLocation.isEmpty()) continue;
                theLocation = this.get(theDenizen.getName(), thisLocation.split(" ", 2)[0], BookmarkType.LOCATION);
                theInfo = "ID:" + theDenizen.getId() + ":" + thisLocation.split(" ", 2)[0];
                this.locationTriggerList.put(theLocation, theInfo);
            }
        }
        this.plugin.getLogger().log(Level.INFO, "Building Location Bookmark Trigger List. Size: " + this.locationTriggerList.size());
        if (this.plugin.debugMode.booleanValue() && this.locationTriggerList.size() > 0) {
            this.plugin.getLogger().log(Level.INFO, "Item Key: [Type]:[Assigned To]:[Name of Bookmark]" + this.locationTriggerList.size());
            for (String theEntry : this.locationTriggerList.values()) {
                this.plugin.getLogger().log(Level.INFO, "Item added to list: " + theEntry);
            }
        }
    }

    public Map<Location, String> getLocationTriggerList() {
        return this.locationTriggerList;
    }

    public boolean exists(String theDenizen, String nameOfLocation) {
        if (nameOfLocation.split(":").length == 2) {
            theDenizen = nameOfLocation.split(":")[0];
        }
        if (this.plugin.getSaves().contains("Denizens." + theDenizen + ".Bookmarks.Location")) {
            for (String theLocationBookmark : this.plugin.getSaves().getStringList("Denizens." + theDenizen + ".Bookmarks.Location")) {
                if (!theLocationBookmark.contains(nameOfLocation)) continue;
                return true;
            }
        }
        if (this.plugin.getSaves().contains("Denizens." + theDenizen + ".Bookmarks.Block")) {
            for (String theLocationBookmark : this.plugin.getSaves().getStringList("Denizens." + theDenizen + ".Bookmarks.Block")) {
                if (!theLocationBookmark.contains(nameOfLocation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean exists(DenizenNPC theDenizen, String nameOfLocation) {
        String theName = null;
        theName = theDenizen == null ? "null" : theDenizen.getName();
        return this.exists(theName, nameOfLocation);
    }

    public Location get(DenizenNPC theDenizen, String nameOfLocation, BookmarkType bookmarkType) {
        String theName = null;
        theName = theDenizen == null ? "null" : theDenizen.getName();
        return this.get(theName, nameOfLocation, bookmarkType);
    }

    public Location get(String theDenizen, String nameOfLocation, BookmarkType bookmarkType) {
        List locationList = null;
        String[] theLocation = null;
        Location locationBookmark = null;
        try {
            if (nameOfLocation.split(":").length == 2) {
                theDenizen = nameOfLocation.split(":")[0];
            }
            if (bookmarkType == BookmarkType.BLOCK) {
                locationList = this.plugin.getSaves().getStringList("Denizens." + theDenizen + ".Bookmarks.Block");
            } else if (bookmarkType == BookmarkType.LOCATION) {
                locationList = this.plugin.getSaves().getStringList("Denizens." + theDenizen + ".Bookmarks.Location");
            }
            for (String thisLocation : locationList) {
                String theName = thisLocation.split(" ", 2)[0];
                if (!theName.equalsIgnoreCase(nameOfLocation)) continue;
                theLocation = thisLocation.split(" ", 2)[1].split(";");
            }
            if (theLocation != null && bookmarkType == BookmarkType.LOCATION) {
                locationBookmark = new Location(this.plugin.getServer().getWorld((String)theLocation[0]), Double.parseDouble((String)theLocation[1]), Double.parseDouble(theLocation[2] + 1), Double.parseDouble(theLocation[3]), Float.parseFloat(theLocation[4]), Float.parseFloat(theLocation[5]));
            } else if (theLocation != null && bookmarkType == BookmarkType.BLOCK) {
                locationBookmark = new Location(this.plugin.getServer().getWorld((String)theLocation[0]), Double.parseDouble((String)theLocation[1]), Double.parseDouble((String)theLocation[2]), Double.parseDouble(theLocation[3]));
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Failed to get a Bookmark.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return locationBookmark;
    }

    public static enum BookmarkType {
        LOCATION,
        BLOCK;

    }
}

