/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.bookmarks.BookmarkHelper;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArgumentHelper {
    Denizen plugin;
    public final Pattern npcIDArgument = Pattern.compile("(?:NPCID|npcid)(:)(\\d+)");
    public final Pattern materialArgument = Pattern.compile("\\d+");
    public final Pattern materialArgument2 = Pattern.compile("(\\d+)(:)(\\d+)");
    public final Pattern materialArgument3 = Pattern.compile("([a-zA-Z\\x5F]+)");
    public final Pattern materialArgument4 = Pattern.compile("([a-zA-Z]+?)(:)(\\d+)");
    public final Pattern durationArgument = Pattern.compile("(?:DURATION|duration|Duration)(:)(\\d+)");
    public final Pattern queuetypeArgument = Pattern.compile("(?:QUEUE|queue|Queue)(:)(?:TASK|Task|Trigger|TRIGGER)");
    public final Pattern worldArgument = Pattern.compile("(?:WORLD|world|World)(:)([a-zA-Z0-9]+?)");
    public final Pattern groupArgument = Pattern.compile("(?:GROUP|group|Group)(:)([a-zA-Z0-9]+?)");
    public final Pattern integerArgument = Pattern.compile("\\d+");
    public final Pattern scriptArgument = Pattern.compile("(?:SCRIPT|script|Script)(:)(.+)");
    public final Pattern quantityArgument = Pattern.compile("(?:QTY|qty|Qty)(:)(\\d+)");
    public final Pattern bookmarkArgument = Pattern.compile("(?:bookmark|BOOKMARK|Bookmark)(:)(\\w+)(:)(\\w+)");
    public final Pattern bookmarkArgument2 = Pattern.compile("(?:bookmark|BOOKMARK|Bookmark)(:)(\\w+)");
    public final Pattern replaceableFlag = Pattern.compile("(<)(\\^FLAG|FLAG)(.G|.GLOBAL|.P|.PLAYER|.D|.DENIZEN)(:)(.*?)(>)");

    ArgumentHelper(Denizen plugin) {
        this.plugin = plugin;
    }

    public void echoDebug(String message, String argument) {
        ConsoleCommandSender cs = this.plugin.getServer().getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + String.format(message, argument));
        }
    }

    public void echoDebug(String message) {
        ConsoleCommandSender cs = this.plugin.getServer().getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + message);
        }
    }

    public void echoError(String message) {
        ConsoleCommandSender cs = this.plugin.getServer().getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + message);
        }
    }

    public void echoError(String message, String argument) {
        ConsoleCommandSender cs = this.plugin.getServer().getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + String.format(message, argument));
        }
    }

    public String getStringModifier(String argument) {
        if (argument.split(":").length >= 2) {
            return argument.split(":")[1];
        }
        return argument;
    }

    public ScriptEngine.QueueType getQueueModifier(String argument) {
        try {
            if (argument.split(":").length >= 2) {
                return ScriptEngine.QueueType.valueOf(argument.split(":")[1].toUpperCase());
            }
            return ScriptEngine.QueueType.valueOf(argument.toUpperCase());
        }
        catch (Exception e) {
            this.echoError("Invalid Queuetype!");
            return null;
        }
    }

    public Integer getIntegerModifier(String argument) {
        if (argument.split(":").length >= 2) {
            return Integer.valueOf(argument.split(":")[1]);
        }
        return Integer.valueOf(argument);
    }

    public Location getBookmarkModifier(String thisArg, DenizenNPC denizenNPC) {
        Matcher m = this.bookmarkArgument.matcher(thisArg);
        Matcher m2 = this.bookmarkArgument2.matcher(thisArg);
        if (m.matches()) {
            if (this.plugin.bookmarks.exists(thisArg.split(":")[1], thisArg.split(":")[2])) {
                return this.plugin.bookmarks.get(thisArg.split(":")[1], thisArg.split(":")[2], BookmarkHelper.BookmarkType.LOCATION);
            }
        } else if (m2.matches() && this.plugin.bookmarks.exists(denizenNPC, thisArg.split(":")[1])) {
            return this.plugin.bookmarks.get(denizenNPC, thisArg.split(":")[1], BookmarkHelper.BookmarkType.LOCATION);
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.echoError("...bookmark not found!");
        }
        return null;
    }

    public Location getBlockBookmarkModifier(String thisArg, DenizenNPC denizenNPC) {
        Matcher m = this.bookmarkArgument.matcher(thisArg);
        Matcher m2 = this.bookmarkArgument2.matcher(thisArg);
        if (m.matches()) {
            if (this.plugin.bookmarks.exists(thisArg.split(":")[1], thisArg.split(":")[2])) {
                return this.plugin.bookmarks.get(thisArg.split(":")[1], thisArg.split(":")[2], BookmarkHelper.BookmarkType.BLOCK);
            }
        } else if (m2.matches() && this.plugin.bookmarks.exists(denizenNPC, thisArg.split(":")[1])) {
            return this.plugin.bookmarks.get(denizenNPC, thisArg.split(":")[1], BookmarkHelper.BookmarkType.BLOCK);
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.echoError("...block bookmark not found!");
        }
        return null;
    }

    public ItemStack getItemModifier(String thisArg) {
        ItemStack theItem;
        block7: {
            Matcher m = this.materialArgument.matcher(thisArg);
            Matcher m2 = this.materialArgument2.matcher(thisArg);
            Matcher m3 = this.materialArgument3.matcher(thisArg);
            Matcher m4 = this.materialArgument4.matcher(thisArg);
            theItem = null;
            try {
                if (m.matches()) {
                    theItem = new ItemStack(Integer.valueOf(thisArg).intValue());
                }
                if (m2.matches()) {
                    theItem = new ItemStack(Integer.valueOf(thisArg.split(":")[0]).intValue());
                    theItem.setDurability(Short.valueOf(thisArg.split(":")[1]).shortValue());
                }
                if (m3.matches()) {
                    theItem = new ItemStack(Material.valueOf((String)thisArg.toUpperCase()));
                }
                if (m4.matches()) {
                    theItem = new ItemStack(Material.valueOf((String)thisArg.split(":")[0].toUpperCase()));
                    theItem.setDurability(Short.valueOf(thisArg.split(":")[1]).shortValue());
                }
            }
            catch (Exception e) {
                if (this.plugin.debugMode.booleanValue()) {
                    this.echoError("...invalid item!");
                }
                if (!this.plugin.showStackTraces) break block7;
                e.printStackTrace();
            }
        }
        return theItem;
    }

    public DenizenNPC getNPCIDModifier(String thisArg) {
        DenizenNPC denizen;
        block4: {
            Matcher m = this.npcIDArgument.matcher(thisArg);
            denizen = null;
            if (m.matches()) {
                try {
                    if (CitizensAPI.getNPCRegistry().getById(Integer.valueOf(thisArg.split(":")[1]).intValue()) != null) {
                        denizen = this.plugin.getDenizenNPCRegistry().getDenizen(CitizensAPI.getNPCRegistry().getById(Integer.valueOf(thisArg.split(":")[1]).intValue()));
                    }
                }
                catch (Exception e) {
                    if (!this.plugin.debugMode.booleanValue()) break block4;
                    this.echoError("...NPCID specified could not be matched to a Denizen!");
                }
            }
        }
        return denizen;
    }

    public boolean matchesNPCID(String regex) {
        Matcher m = this.npcIDArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesItem(String regex) {
        Matcher m = this.materialArgument.matcher(regex);
        Matcher m2 = this.materialArgument2.matcher(regex);
        Matcher m3 = this.materialArgument3.matcher(regex);
        Matcher m4 = this.materialArgument4.matcher(regex);
        return m.matches() || m2.matches() || m3.matches() || m4.matches();
    }

    public boolean matchesDuration(String regex) {
        Matcher m = this.durationArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesQueueType(String regex) {
        Matcher m = this.queuetypeArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesWorld(String regex) {
        Matcher m = this.worldArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesGroup(String regex) {
        Matcher m = this.groupArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesInteger(String regex) {
        Matcher m = this.integerArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesScript(String regex) {
        Matcher m = this.scriptArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesQuantity(String regex) {
        Matcher m = this.quantityArgument.matcher(regex);
        return m.matches();
    }

    public boolean matchesBookmark(String regex) {
        Matcher m = this.bookmarkArgument.matcher(regex);
        Matcher n = this.bookmarkArgument2.matcher(regex);
        return m.matches() || n.matches();
    }

    public String fillReplaceables(Player thePlayer, DenizenNPC theDenizen, String stringToFill, boolean quickReplaceable) {
        if (stringToFill == null) {
            return null;
        }
        Matcher f = this.replaceableFlag.matcher(stringToFill);
        StringBuffer sb = new StringBuffer(stringToFill.length());
        String filledString = stringToFill;
        while (f.find()) {
            if (f.group(2).contains("^") && !quickReplaceable || !f.group(2).contains("^") && quickReplaceable) continue;
            String searchPath = "";
            if (f.group(3).startsWith(".G")) {
                searchPath = "Global.Flags.";
            } else if (f.group(3).startsWith(".D") && theDenizen != null) {
                searchPath = "Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags.";
            } else if (f.group(3).startsWith(".P") && thePlayer != null) {
                searchPath = "Players." + thePlayer.getName() + ".Flags.";
            }
            if (f.group(5).split(":").length > 1) {
                if (this.plugin.getSaves().contains(searchPath + f.group(5).split(":")[0].toUpperCase())) {
                    f.appendReplacement(sb, this.plugin.getSaves().getString(searchPath + f.group(5).split(":")[0].toUpperCase()));
                    this.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' with flag value.", f.group(5));
                    continue;
                }
                f.appendReplacement(sb, f.group(5).split(":")[1]);
                this.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' flag not found, using fallback!", f.group(5));
                continue;
            }
            if (this.plugin.getSaves().contains(searchPath + f.group(5).toUpperCase())) {
                f.appendReplacement(sb, this.plugin.getSaves().getString(searchPath + f.group(5).split(":")[0].toUpperCase()));
                this.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' with flag value.", f.group(5));
                continue;
            }
            f.appendReplacement(sb, "");
            this.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' flag not found!", f.group(5));
        }
        f.appendTail(sb);
        filledString = sb.toString();
        if (thePlayer != null && filledString.contains("<")) {
            String itemInHandMaterial = "AIR";
            if (thePlayer.getItemInHand() != null) {
                itemInHandMaterial = thePlayer.getItemInHand().getType().name();
            }
            String itemInHandName = "nothing";
            if (thePlayer.getItemInHand() != null) {
                itemInHandName = thePlayer.getItemInHand().getType().name().toLowerCase().replace("_", " ");
            }
            String itemInHandQty = "0";
            if (thePlayer.getItemInHand() != null) {
                itemInHandQty = String.valueOf(thePlayer.getItemInHand().getAmount());
            }
            String itemInHandId = "0";
            if (thePlayer.getItemInHand() != null) {
                itemInHandId = String.valueOf(thePlayer.getItemInHand().getTypeId());
            }
            String playerKiller = "nobody";
            if (thePlayer.getKiller() != null) {
                playerKiller = thePlayer.getKiller().getName();
            }
            String playerHelm = "FALSE";
            if (thePlayer.getInventory().getHelmet() != null) {
                playerHelm = thePlayer.getInventory().getHelmet().getType().name();
            }
            String playerBoots = "FALSE";
            if (thePlayer.getInventory().getBoots() != null) {
                playerBoots = thePlayer.getInventory().getBoots().getType().name();
            }
            String playerChestplate = "FALSE";
            if (thePlayer.getInventory().getChestplate() != null) {
                playerChestplate = thePlayer.getInventory().getChestplate().getType().name();
            }
            String playerLeggings = "FALSE";
            if (thePlayer.getInventory().getLeggings() != null) {
                playerLeggings = thePlayer.getInventory().getLeggings().getType().name();
            }
            String playerMoney = "0";
            if (this.plugin.economy != null) {
                playerMoney = String.valueOf(this.plugin.economy.getBalance(thePlayer.getName()));
            }
            filledString = quickReplaceable ? filledString.replace("<^PLAYER.ITEM_IN_HAND.MATERIAL>", itemInHandMaterial).replace("<^PLAYER.ITEM_IN_HAND.NAME>", itemInHandName).replace("<^PLAYER.ITEM_IN_HAND.QTY>", itemInHandQty).replace("<^PLAYER.ITEM_IN_HAND.ID>", itemInHandId).replace("<^PLAYER.NAME>", thePlayer.getName()).replace("<^PLAYER>", thePlayer.getName()).replace("<^PLAYER.KILLER>", playerKiller).replace("<^PLAYER.HEALTH>", String.valueOf(thePlayer.getHealth())).replace("<^PLAYER.HELM>", playerHelm).replace("<^PLAYER.LEGGINGS>", playerLeggings).replace("<^PLAYER.BOOTS>", playerBoots).replace("<^PLAYER.CHESTPLATE>", playerChestplate).replace("<^PLAYER.WORLD>", thePlayer.getWorld().getName()).replace("<^PLAYER.MONEY>", playerMoney).replace("<^PLAYER.EXP_TO_NEXT_LEVEL>", String.valueOf(thePlayer.getExpToLevel())).replace("<^PLAYER.EXP>", String.valueOf(thePlayer.getTotalExperience())).replace("<^PLAYER.FOOD_LEVEL>", String.valueOf(thePlayer.getFoodLevel())) : filledString.replace("<PLAYER.ITEM_IN_HAND.MATERIAL>", itemInHandMaterial).replace("<PLAYER.ITEM_IN_HAND.QTY>", itemInHandQty).replace("<PLAYER.ITEM_IN_HAND.ID>", itemInHandId).replace("<PLAYER.NAME>", thePlayer.getName()).replace("<PLAYER>", thePlayer.getName()).replace("<PLAYER.KILLER>", playerKiller).replace("<PLAYER.HEALTH>", String.valueOf(thePlayer.getHealth())).replace("<PLAYER.HELM>", playerHelm).replace("<PLAYER.LEGGINGS>", playerLeggings).replace("<PLAYER.BOOTS>", playerBoots).replace("<PLAYER.CHESTPLATE>", playerChestplate).replace("<PLAYER.WORLD>", thePlayer.getWorld().getName()).replace("<PLAYER.MONEY>", playerMoney).replace("<PLAYER.EXP_TO_NEXT_LEVEL>", String.valueOf(thePlayer.getExpToLevel())).replace("<PLAYER.EXP>", String.valueOf(thePlayer.getTotalExperience())).replace("<PLAYER.FOOD_LEVEL>", String.valueOf(thePlayer.getFoodLevel()));
        }
        if (theDenizen != null && filledString.contains("<")) {
            filledString = quickReplaceable ? filledString.replace("<^DENIZEN.NPCID>", String.valueOf(theDenizen.getId())).replace("<^NPCID>", String.valueOf(theDenizen.getId())).replace("<^NPC>", theDenizen.getName()).replace("<^DENIZEN.NAME>", theDenizen.getName()) : filledString.replace("<DENIZEN.NPCID>", String.valueOf(theDenizen.getId())).replace("<NPCID>", String.valueOf(theDenizen.getId())).replace("<NPC>", theDenizen.getName()).replace("<DENIZEN.NAME>", theDenizen.getName()).replace("<NPC.ENTITYID>", String.valueOf(theDenizen.getEntity().getEntityId()));
        }
        return filledString;
    }
}

