/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        String potionName = null;
        int duration = 60;
        int amplitude = 1;
        Player target = theEntry.getPlayer();
        if (theEntry.arguments() == null) {
            throw new CommandException("Usage: CAST [SpellName] (DURATION:#) (POWER:#) (NPC:#) (PLAYER:PlayerName)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (thisArg.toUpperCase().contains("SPELL:")) {
                potionName = this.aH.getStringModifier(thisArg);
                this.aH.echoDebug("...will cast effect '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesDuration(thisArg)) {
                duration = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...duration set to '%s'.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().contains("POWER:")) {
                amplitude = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...power set to '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                target = this.aH.getNPCIDModifier(thisArg).getEntity();
                if (target == null) continue;
                this.aH.echoDebug("...now targeting '%s'.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().contains("PLAYER:")) {
                target = theEntry.getDenizen().getEntity().getServer().getPlayer(this.aH.getStringModifier(thisArg));
                if (target == null) continue;
                this.aH.echoDebug("...now targeting '%s'.", thisArg);
                continue;
            }
            potionName = this.aH.getStringModifier(thisArg);
            this.aH.echoDebug("...will cast effect '%s'.", thisArg);
        }
        if (target == null) {
            this.aH.echoError("Could not find target! Perhaps you specified a non-existing NPCID?");
            return false;
        }
        if (potionName != null) {
            try {
                target.addPotionEffect(new PotionEffect(PotionEffectType.getByName(potionName), duration * 20, amplitude));
                return true;
            }
            catch (Exception e) {
                this.aH.echoError("Invalid potion effect! Check syntax.");
                return false;
            }
        }
        this.aH.echoError("Usage: CAST [SpellName] (DURATION:#) (POWER:#) (NPC:#) (PLAYER:PlayerName)");
        return false;
    }
}

