/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;

public class DropCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        int theAmount = 1;
        ItemStack theItem = null;
        Location theLocation = null;
        Enum dropType = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: DROP [#(:#)|MATERIAL_TYPE(:#)] (QTY:#) (BOOKMARK:LocationBookmark)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesQuantity(thisArg)) {
                theAmount = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...drop quantity now '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesBookmark(thisArg)) {
                theLocation = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (theLocation == null) continue;
                this.aH.echoDebug("...drop location now at bookmark '%s'", thisArg);
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                theLocation = this.aH.getNPCIDModifier(thisArg).getLocation();
                if (theLocation == null) continue;
                this.aH.echoDebug("...now targeting '%s'.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().contains("XP")) {
                dropType = DropType.EXP;
                this.aH.echoDebug("...giving '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesItem(thisArg)) {
                theItem = this.aH.getItemModifier(thisArg);
                dropType = DropType.ITEM;
                if (theItem == null) continue;
                this.aH.echoDebug("...set ItemID to '%s'.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        if (theLocation == null && theEntry.getDenizen() == null) {
            this.aH.echoError("Seems this was sent from a TASK-type script. Must use BOOKMARK:location or NPCID:# to specify a drop location!");
            return false;
        }
        if (theLocation == null) {
            theLocation = theEntry.getDenizen().getLocation();
        }
        if (dropType != null) {
            switch (1.$SwitchMap$net$aufdemrand$denizen$commands$core$DropCommand$DropType[dropType.ordinal()]) {
                case 1: {
                    theItem.setAmount(theAmount);
                    theEntry.getDenizen().getWorld().dropItemNaturally(theLocation, theItem);
                    return true;
                }
                case 2: {
                    ((ExperienceOrb)theEntry.getDenizen().getWorld().spawn(theLocation, ExperienceOrb.class)).setExperience(theAmount);
                    return true;
                }
            }
        }
        return false;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$commands$core$DropCommand$DropType;

        static {
            $SwitchMap$net$aufdemrand$denizen$commands$core$DropCommand$DropType = new int[DropType.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$DropCommand$DropType[DropType.ITEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$DropCommand$DropType[DropType.EXP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum DropType {
        ITEM,
        EXP;

    }
}

