/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;

public class EngageCommand
extends AbstractCommand {
    private Map<DenizenNPC, Long> engagedNPC = new HashMap<DenizenNPC, Long>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Integer timedEngage = null;
        DenizenNPC theDenizen = theEntry.getDenizen();
        if (theEntry.arguments() != null) {
            for (String thisArg : theEntry.arguments()) {
                if (thisArg.contains("<")) {
                    thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                }
                if (this.aH.matchesInteger(thisArg)) {
                    timedEngage = Integer.valueOf(thisArg);
                    this.aH.echoDebug("...engage duration set to '%s'.", thisArg);
                    continue;
                }
                if (this.aH.matchesDuration(thisArg)) {
                    timedEngage = this.aH.getIntegerModifier(thisArg);
                    this.aH.echoDebug("...engage duration set to '%s'.", thisArg);
                    continue;
                }
                if (this.aH.matchesNPCID(thisArg)) {
                    theDenizen = this.aH.getNPCIDModifier(thisArg);
                    if (theDenizen == null) continue;
                    this.aH.echoDebug("...now referencing '%s'.", thisArg);
                    continue;
                }
                this.aH.echoError("...unable to match '%s'!", thisArg);
            }
        }
        if (theDenizen == null) {
            this.aH.echoError("Seems this was sent from a TASK-type script. Must use NPCID:# to specify a Denizen NPC!");
            return false;
        }
        if (theEntry.getCommand().equalsIgnoreCase("DISENGAGE")) {
            this.setEngaged(theEntry.getDenizen(), false);
            return true;
        }
        if (timedEngage != null) {
            this.setEngaged(theDenizen, timedEngage);
        } else {
            this.setEngaged(theEntry.getDenizen(), true);
        }
        return true;
    }

    public boolean getEngaged(DenizenNPC theDenizen) {
        return this.engagedNPC.containsKey(theDenizen) && this.engagedNPC.get(theDenizen) > System.currentTimeMillis();
    }

    public void setEngaged(DenizenNPC theDenizen, boolean engaged) {
        if (engaged) {
            this.engagedNPC.put(theDenizen, System.currentTimeMillis() + (long)(this.plugin.settings.EngageTimeoutInSeconds() * 1000));
        }
        if (!engaged) {
            this.engagedNPC.remove(theDenizen);
        }
    }

    public void setEngaged(DenizenNPC theDenizen, Integer duration) {
        this.engagedNPC.put(theDenizen, System.currentTimeMillis() + (long)(duration * 1000));
    }
}

