/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ExecuteCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        String commandtoExecute = null;
        ExecuteType executeType = null;
        DenizenNPC theDenizen = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: EXECUTE [AS_SERVER|AS_NPC|AS_PLAYER] '[Command to execute]'");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (thisArg.equalsIgnoreCase("ASPLAYER") || thisArg.equalsIgnoreCase("AS_PLAYER")) {
                executeType = ExecuteType.ASPLAYER;
                this.aH.echoDebug("...executing '%s'.", thisArg);
            }
            if (thisArg.equalsIgnoreCase("ASOPPLAYER") || thisArg.equalsIgnoreCase("AS_OP_PLAYER")) {
                executeType = ExecuteType.ASOPPLAYER;
                this.aH.echoDebug("...executing '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                theDenizen = this.aH.getNPCIDModifier(thisArg);
                if (theDenizen == null) continue;
                this.aH.echoDebug("...now referencing '%s'.", thisArg);
                continue;
            }
            if (thisArg.equalsIgnoreCase("ASNPC") || thisArg.equalsIgnoreCase("AS_NPC")) {
                executeType = ExecuteType.ASDENIZEN;
                this.aH.echoDebug("...executing '%s'.", thisArg);
                continue;
            }
            if (thisArg.equalsIgnoreCase("ASSERVER") || thisArg.equalsIgnoreCase("AS_SERVER")) {
                executeType = ExecuteType.ASSERVER;
                this.aH.echoDebug("...executing '%s'.", thisArg);
                continue;
            }
            commandtoExecute = thisArg;
            this.aH.echoDebug("...executing command '%s'.", thisArg);
        }
        if (theDenizen == null && theEntry.getDenizen() != null) {
            theDenizen = theEntry.getDenizen();
        }
        if (theEntry.getTexts()[0] != null) {
            commandtoExecute = commandtoExecute.replace("<*>", theEntry.getTexts()[0]);
        }
        if (commandtoExecute != null && executeType != null) {
            switch (executeType) {
                case ASPLAYER: {
                    theEntry.getPlayer().performCommand(commandtoExecute);
                    break;
                }
                case ASOPPLAYER: {
                    boolean isOp = false;
                    if (theEntry.getPlayer().isOp()) {
                        isOp = true;
                    }
                    if (!isOp) {
                        theEntry.getPlayer().setOp(true);
                    }
                    theEntry.getPlayer().performCommand(commandtoExecute);
                    if (isOp) break;
                    theEntry.getPlayer().setOp(false);
                    break;
                }
                case ASDENIZEN: {
                    if (theDenizen == null) {
                        this.aH.echoError("Seems this was sent from a TASK-type script. Must use NPCID:# to specify a Denizen NPC when executing AS_DENIZEN!");
                        return false;
                    }
                    if (theDenizen.getCitizensEntity().getBukkitEntity().getType() == EntityType.PLAYER) {
                        ((Player)theDenizen.getEntity()).setOp(true);
                        ((Player)theDenizen.getEntity()).performCommand(commandtoExecute);
                        ((Player)theDenizen.getEntity()).setOp(false);
                        break;
                    }
                    this.aH.echoError("Cannot EXECUTE AS_NPC unless NPC is Human!");
                    break;
                }
                case ASSERVER: {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), commandtoExecute);
                }
            }
            return true;
        }
        return false;
    }

    static enum ExecuteType {
        ASSERVER,
        ASDENIZEN,
        ASPLAYER,
        ASOPPLAYER;

    }
}

