/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.runnables.FourItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class FlagCommand
extends AbstractCommand {
    private Map<String, Integer> taskMap = new ConcurrentHashMap<String, Integer>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        String theFlag = null;
        Enum flagType = null;
        Integer duration = null;
        String theValue = null;
        boolean global = false;
        DenizenNPC theDenizen = null;
        boolean isDenizen = false;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: FLAG [[NAME]:[VALUE]|[NAME]:++|[NAME]:--]");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesDuration(thisArg)) {
                duration = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...flag will be removed after '%s' seconds.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().equals("GLOBAL")) {
                global = true;
                this.aH.echoDebug("...this flag will be GLOBAL.");
                continue;
            }
            if (thisArg.toUpperCase().equals("DENIZEN")) {
                if (theEntry.getDenizen() != null) {
                    theDenizen = theEntry.getDenizen();
                    isDenizen = true;
                    this.aH.echoDebug("...this flag will be bound to the DENIZEN.");
                    continue;
                }
                this.aH.echoError("No NPC found!");
                return false;
            }
            if (thisArg.toUpperCase().equals("PLAYER")) {
                this.aH.echoDebug("...this flag will be bound to the PLAYER.");
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                theDenizen = this.aH.getNPCIDModifier(thisArg);
                if (theDenizen == null) {
                    this.aH.echoError("No NPC found!");
                    return false;
                }
                isDenizen = true;
                this.aH.echoDebug("...changing referenced NPC to '%s'.", theDenizen.getName());
                continue;
            }
            if (thisArg.split(":").length == 2) {
                theFlag = thisArg.split(":")[0].toUpperCase();
                if (thisArg.split(":")[1].equals("++")) {
                    flagType = FlagType.INC;
                } else if (thisArg.split(":")[1].equals("--")) {
                    flagType = FlagType.DEC;
                } else {
                    flagType = FlagType.VALUE;
                    theValue = thisArg.split(":")[1];
                }
                this.aH.echoDebug("...setting FLAG '%s'.", thisArg);
                continue;
            }
            theFlag = thisArg.toUpperCase();
            theValue = "TRUE";
            flagType = FlagType.BOOLEAN;
            this.aH.echoDebug("...setting '%s' as boolean flag.", thisArg.toUpperCase());
        }
        if (theEntry.getTexts()[0] != null && theValue != null && theValue.contains("<*>")) {
            theValue = theValue.replace("<*>", theEntry.getTexts()[0]);
        }
        if (duration != null && flagType != null && theFlag != null) {
            this.aH.echoDebug("Setting delayed task: RESET FLAG '%s'", theFlag);
            String flagKey = theEntry.getPlayer().getName() + " " + theFlag;
            if (global) {
                flagKey = "GLOBAL " + theFlag;
            }
            if (isDenizen) {
                flagKey = theDenizen.getName() + "." + theDenizen.getId() + " " + theFlag;
            }
            if (this.taskMap.containsKey(flagKey)) {
                try {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskMap.get(flagKey).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            flagKey = flagKey.split(" ")[0];
            this.taskMap.put(flagKey, this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new FourItemRunnable<String, String, String, Boolean>(flagKey, theFlag, theValue, Boolean.valueOf(isDenizen)){

                @Override
                public void run(String player, String flag, String checkValue, Boolean denizen) {
                    if (player.equals("GLOBAL")) {
                        FlagCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET GLOBAL FLAG '" + flag + ".");
                        if (FlagCommand.this.plugin.getSaves().contains("Global.Flags." + flag) && FlagCommand.this.plugin.getSaves().getString("Global.Flags." + flag).equals(checkValue)) {
                            FlagCommand.this.plugin.getSaves().set("Global.Flags." + flag, null);
                        }
                    } else if (denizen.booleanValue()) {
                        FlagCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET FLAG '" + flag + "' for " + player + ".");
                        if (FlagCommand.this.plugin.getSaves().contains("Denizens." + player + ".Flags." + flag) && FlagCommand.this.plugin.getSaves().getString("Denizens." + player + ".Flags." + flag).equals(checkValue)) {
                            FlagCommand.this.plugin.getSaves().set("Denizens." + player + ".Flags." + flag, null);
                        }
                    } else {
                        FlagCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET FLAG '" + flag + "' for " + player + ".");
                        if (FlagCommand.this.plugin.getSaves().contains("Players." + player + ".Flags." + flag) && FlagCommand.this.plugin.getSaves().getString("Players." + player + ".Flags." + flag).equals(checkValue)) {
                            FlagCommand.this.plugin.getSaves().set("Players." + player + ".Flags." + flag, null);
                        }
                    }
                }
            }, (long)(duration * 20)));
        }
        if (flagType != null && theFlag != null) {
            switch (2.$SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType[flagType.ordinal()]) {
                case 1: {
                    try {
                        if (global) {
                            double incValue = Double.valueOf(this.plugin.getSaves().getString("Global.Flags." + theFlag, "0")) + 1.0;
                            this.plugin.getSaves().set("Global.Flags." + theFlag, (Object)incValue);
                            break;
                        }
                        if (isDenizen) {
                            double incValue = Double.valueOf(this.plugin.getSaves().getString("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, "0")) + 1.0;
                            this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, (Object)incValue);
                            break;
                        }
                        double incValue = Double.valueOf(this.plugin.getSaves().getString("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, "0")) + 1.0;
                        this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, (Object)incValue);
                    }
                    catch (NumberFormatException e) {
                        this.aH.echoError("Cannot increment a non-integer flag!");
                    }
                    break;
                }
                case 2: {
                    try {
                        if (global) {
                            double incValue = Double.valueOf(this.plugin.getSaves().getString("Global.Flags." + theFlag, "0")) - 1.0;
                            this.plugin.getSaves().set("Global.Flags." + theFlag, (Object)incValue);
                            break;
                        }
                        if (isDenizen) {
                            double incValue = Double.valueOf(this.plugin.getSaves().getString("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, "0")) - 1.0;
                            this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, (Object)incValue);
                            break;
                        }
                        double incValue = Double.valueOf(this.plugin.getSaves().getString("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, "0")) - 1.0;
                        this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, (Object)incValue);
                    }
                    catch (NumberFormatException e) {
                        this.aH.echoError("Cannot decrease a non-integer flag!");
                    }
                    break;
                }
                case 3: {
                    if (global) {
                        this.plugin.getSaves().set("Global.Flags." + theFlag, (Object)theValue);
                        break;
                    }
                    if (isDenizen) {
                        this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, (Object)theValue);
                        break;
                    }
                    this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, (Object)theValue);
                    break;
                }
                case 4: {
                    if (global) {
                        this.plugin.getSaves().set("Global.Flags." + theFlag, (Object)theValue);
                        break;
                    }
                    if (isDenizen) {
                        this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Flags." + theFlag, (Object)theValue);
                        break;
                    }
                    this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Flags." + theFlag, (Object)theValue);
                }
            }
            this.plugin.saveSaves();
            return true;
        }
        return false;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType;

        static {
            $SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType = new int[FlagType.values().length];
            try {
                2.$SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType[FlagType.INC.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType[FlagType.DEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType[FlagType.VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$net$aufdemrand$denizen$commands$core$FlagCommand$FlagType[FlagType.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum FlagType {
        VALUE,
        INC,
        DEC,
        BOOLEAN;

    }
}

