/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Enum giveType = null;
        int theAmount = 1;
        ItemStack theItem = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: GIVE [MONEY|#(:#)|MATERIAL_TYPE(:#)] (QTY:#)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesQuantity(thisArg)) {
                theAmount = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...set quantity to '%s'.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().equals("MONEY")) {
                giveType = GiveType.MONEY;
                this.aH.echoDebug("...giving MONEY.");
                continue;
            }
            if (thisArg.toUpperCase().contains("HEROESEXP") || thisArg.toUpperCase().contains("HEROES_EXP")) {
                giveType = GiveType.HEROESEXP;
                this.aH.echoDebug("...giving Heroes Quest EXP.");
                continue;
            }
            if (thisArg.toUpperCase().contains("XP") || thisArg.toUpperCase().contains("EXP")) {
                giveType = GiveType.EXP;
                this.aH.echoDebug("...giving EXP.");
                continue;
            }
            if (this.aH.matchesItem(thisArg)) {
                theItem = this.aH.getItemModifier(thisArg);
                giveType = GiveType.ITEM;
                if (theItem == null) continue;
                this.aH.echoDebug("...set item to be given to '%s'.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        if (giveType != null) {
            switch (1.$SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType[giveType.ordinal()]) {
                case 1: {
                    if (this.plugin.economy != null) {
                        double doubleAmount = theAmount;
                        this.plugin.economy.depositPlayer(theEntry.getPlayer().getName(), doubleAmount);
                    } else {
                        this.aH.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    }
                    return true;
                }
                case 2: {
                    theEntry.getPlayer().giveExp(theAmount);
                    return true;
                }
                case 3: {
                    theItem.setAmount(theAmount);
                    HashMap leftovers = theEntry.getPlayer().getInventory().addItem(new ItemStack[]{theItem});
                    if (!leftovers.isEmpty()) {
                        if (this.plugin.debugMode.booleanValue()) {
                            this.aH.echoDebug("...Player did not have enough space in their inventory, the rest of the items have been placed on the floor.");
                        }
                        for (Map.Entry leftoverItem : leftovers.entrySet()) {
                            theEntry.getPlayer().getWorld().dropItem(theEntry.getPlayer().getLocation(), (ItemStack)leftoverItem.getValue());
                        }
                    }
                    return true;
                }
                case 4: {
                    if (this.plugin.heroes != null) {
                        Hero theHero = this.plugin.heroes.getCharacterManager().getHero(theEntry.getPlayer());
                        theHero.gainExp((double)theAmount, HeroClass.ExperienceType.QUESTING, theEntry.getPlayer().getLocation());
                    } else {
                        this.aH.echoError("Could not find Heroes!");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType;

        static {
            $SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType = new int[GiveType.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType[GiveType.MONEY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType[GiveType.EXP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType[GiveType.ITEM.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$GiveCommand$GiveType[GiveType.HEROESEXP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum GiveType {
        ITEM,
        MONEY,
        EXP,
        HEROESEXP;

    }
}

