/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.ArrayList;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.ChatColor;

public class HintCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        boolean shortFormat = false;
        if (theEntry.arguments() != null) {
            for (String thisArg : theEntry.arguments()) {
                if (thisArg.contains("<")) {
                    thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                }
                if (!thisArg.toUpperCase().contains("SHORT")) continue;
                shortFormat = true;
            }
        }
        String theScript = theEntry.getScript();
        Integer theStep = theEntry.getStep();
        ArrayList<String> chatTriggers = new ArrayList<String>();
        String scriptPath = theScript + ".Steps." + theStep + ".Chat Trigger.";
        boolean thisTriggerExists = true;
        int x = 1;
        do {
            if (this.plugin.getScripts().contains(scriptPath + x + ".Trigger")) {
                String ct = this.plugin.getScripts().getString(scriptPath + x + ".Trigger");
                if (!ct.contains("/*/")) {
                    chatTriggers.add(ct);
                }
                this.aH.echoDebug("...found '" + ct + "'");
            } else {
                thisTriggerExists = false;
            }
            ++x;
        } while (thisTriggerExists);
        if (chatTriggers.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.plugin.settings.NpcHintPrefix());
        for (int i = 0; i < chatTriggers.size(); ++i) {
            String item = (String)chatTriggers.get(i);
            String fitem = this.getFormattedTrigger(item, shortFormat);
            this.aH.echoDebug("...formatted " + fitem);
            sb.append(fitem);
            if (i == chatTriggers.size() - 1) continue;
            sb.append(", ");
        }
        theEntry.getPlayer().sendMessage(sb.toString());
        return true;
    }

    private String getFormattedTrigger(String str, boolean shortformat) {
        if (str == null) {
            return "";
        }
        if (shortformat) {
            try {
                int start = str.indexOf("/");
                int end = str.indexOf("/", start + 1);
                if (start != -1 && end != -1 && start != end) {
                    str = str.substring(start, end + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str.replaceFirst("/", ChatColor.UNDERLINE + "").replaceFirst("/", ChatColor.RESET + "");
    }
}

