/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.runnables.ThreeItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HoldCommand
extends AbstractCommand {
    private Map<String, Integer> taskMap = new ConcurrentHashMap<String, Integer>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        ItemStack holdItem = null;
        Integer duration = null;
        if (theEntry.arguments() == null) {
            this.aH.echoError("Not enough arguments! Usage: HOLD [ITEM]");
            return false;
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesItem(thisArg)) {
                holdItem = this.aH.getItemModifier(thisArg);
                if (holdItem == null) continue;
                this.aH.echoDebug("...hold item set to '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesDuration(thisArg)) {
                duration = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...for a duration of '%s' seconds.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        if (holdItem == null) {
            this.aH.echoError("Not enough arguments! Usage: HOLD [ITEM]");
            return false;
        }
        if (!(theEntry.getDenizen().getEntity() instanceof Player)) {
            this.aH.echoError("HOLD command works on 'Human' NPCs only!");
            return false;
        }
        if (duration != null) {
            ItemStack heldItem = ((Player)theEntry.getDenizen()).getInventory().getItemInHand();
            int newItemId = holdItem.getTypeId();
            if (this.taskMap.containsKey(theEntry.getDenizen().getName())) {
                try {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskMap.get(theEntry.getPlayer().getName()).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.aH.echoDebug("Setting delayed task: RESET HOLD ITEM");
            this.taskMap.put(theEntry.getPlayer().getName(), this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ThreeItemRunnable<ItemStack, Integer, DenizenNPC>(heldItem, Integer.valueOf(newItemId), theEntry.getDenizen()){

                @Override
                public void run(ItemStack resetItem, Integer checkItem, DenizenNPC theDenizen) {
                    HoldCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET HELD ITEM for " + theDenizen.getName() + ".");
                    if (((Player)theDenizen.getEntity()).getInventory().getItemInHand().getTypeId() == checkItem.intValue()) {
                        ((Player)theDenizen.getEntity()).setItemInHand(resetItem);
                    }
                }
            }, (long)(duration * 20)));
        }
        ((Player)theEntry.getDenizen().getEntity()).setItemInHand(holdItem);
        return true;
    }
}

