/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.BlockListener;
import net.aufdemrand.denizen.listeners.ItemListener;
import net.aufdemrand.denizen.listeners.KillListener;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.events.ListenerCancelEvent;
import net.aufdemrand.events.ListenerFinishEvent;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ListenCommand
extends AbstractCommand
implements Listener {
    Map<String, AbstractListener> playerListeners = new ConcurrentHashMap<String, AbstractListener>();

    public ListenCommand() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        ListenerType listenerType;
        if (theEntry.arguments() == null) {
            this.aH.echoDebug("...No arguments!");
            return false;
        }
        try {
            listenerType = ListenerType.valueOf(theEntry.arguments()[0].toUpperCase());
        }
        catch (Exception e) {
            this.aH.echoError("Invalid LISTENER_TYPE!");
            return false;
        }
        switch (listenerType) {
            case KILL: {
                String killType = null;
                String killName = "*";
                String killQty = "1";
                String killScript = null;
                String killNPCId = "-1";
                String killListenerId = null;
                for (String thisArg : theEntry.arguments()) {
                    if (thisArg.contains("<")) {
                        thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                    }
                    if (this.aH.matchesScript(thisArg)) {
                        killScript = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...script to run on completion '" + killScript + "'.");
                        continue;
                    }
                    if (thisArg.equalsIgnoreCase("KILL")) {
                        this.aH.echoDebug("...creating new KILL listener.");
                        continue;
                    }
                    if (this.aH.matchesQuantity(thisArg)) {
                        killQty = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...completion on '" + killQty + "' kill(s).");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("NAME:")) {
                        killName = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...kill target is/are '" + thisArg + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("TYPE:")) {
                        killType = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...kill type is '" + killType + "'.");
                        continue;
                    }
                    if (this.aH.matchesNPCID(thisArg)) {
                        killNPCId = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...kill target is '" + thisArg + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("ID:")) {
                        killListenerId = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...kill target is '" + thisArg + "'.");
                        continue;
                    }
                    this.aH.echoError("Could not match argument '%s'!", thisArg);
                }
                if (killListenerId == null && killScript != null) {
                    killListenerId = killScript;
                } else if (killListenerId == null) {
                    killScript = "Kill_Listener_" + System.currentTimeMillis();
                }
                if (killType == null || killName == null || killScript == null || killListenerId == null) {
                    this.aH.echoError("Not enough arguments! Check syntax.");
                    return false;
                }
                List killList = this.plugin.getSaves().getStringList("Players." + theEntry.getPlayer().getName() + ".Listeners.List");
                if (killList.contains(killListenerId)) {
                    this.aH.echoError("Already listening!");
                    return false;
                }
                this.playerListeners.put(theEntry.getPlayer().getName() + ":" + killListenerId, new KillListener());
                this.playerListeners.get(theEntry.getPlayer().getName() + ":" + killListenerId).build(killListenerId, theEntry.getPlayer(), new String[]{killType, killName, killNPCId, killQty}, killScript);
                killList.add(killListenerId);
                this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Listeners.List", (Object)killList);
                return true;
            }
            case BLOCK: {
                String blockType = null;
                String blockName = null;
                String blockQty = "1";
                String blockScript = null;
                String blockListenerId = null;
                for (String thisArg : theEntry.arguments()) {
                    if (thisArg.contains("<")) {
                        thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                    }
                    if (thisArg.equalsIgnoreCase("BLOCK")) {
                        this.aH.echoDebug("...creating new BLOCK listener.");
                        continue;
                    }
                    if (this.aH.matchesScript(thisArg)) {
                        blockScript = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...script to run on completion '" + blockScript + "'.");
                        continue;
                    }
                    if (this.aH.matchesQuantity(thisArg)) {
                        blockQty = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...completion on '" + blockQty + "' block(s).");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("NAME:")) {
                        blockName = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...block(s) to listen for is/are '" + blockName + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("ID:")) {
                        blockListenerId = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...kill target is '" + thisArg + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("TYPE:")) {
                        blockType = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...block event type is '" + blockType + "'.");
                        continue;
                    }
                    this.aH.echoError("Could not match argument '%s'!", thisArg);
                }
                if (blockListenerId == null && blockScript != null) {
                    blockListenerId = blockScript;
                } else if (blockListenerId == null) {
                    blockScript = "Block_Listener_" + System.currentTimeMillis();
                }
                if (blockType == null || blockName == null || blockScript == null || blockListenerId == null) {
                    this.aH.echoError("Not enough arguments! Check syntax.");
                    return false;
                }
                List blockList = this.plugin.getSaves().getStringList("Players." + theEntry.getPlayer().getName() + ".Listeners.List");
                if (blockList.contains(blockListenerId)) {
                    this.aH.echoError("Already listening!");
                    return false;
                }
                this.playerListeners.put(theEntry.getPlayer().getName() + ":" + blockListenerId, new BlockListener());
                this.playerListeners.get(theEntry.getPlayer().getName() + ":" + blockListenerId).build(blockListenerId, theEntry.getPlayer(), new String[]{blockType, blockName, blockQty}, blockScript);
                blockList.add(blockListenerId);
                this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Listeners.List", (Object)blockList);
                return true;
            }
            case ITEM: {
                String itemType = null;
                String itemName = null;
                String itemQty = "1";
                String itemScript = null;
                String itemListenerId = null;
                for (String thisArg : theEntry.arguments()) {
                    if (thisArg.contains("<")) {
                        thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                    }
                    if (thisArg.equalsIgnoreCase("ITEM")) {
                        this.aH.echoDebug("...creating new ITEM listener.");
                        continue;
                    }
                    if (this.aH.matchesScript(thisArg)) {
                        itemScript = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...script to run on completion '" + itemScript + "'.");
                        continue;
                    }
                    if (this.aH.matchesQuantity(thisArg)) {
                        itemQty = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...completion on '" + itemQty + "' item(s).");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("NAME:")) {
                        itemName = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...item(s) to listen for is/are '" + itemName + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("ID:")) {
                        itemListenerId = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...item is '" + thisArg + "'.");
                        continue;
                    }
                    if (thisArg.toUpperCase().contains("TYPE:")) {
                        itemType = this.aH.getStringModifier(thisArg);
                        this.aH.echoDebug("...item event type is '" + itemType + "'.");
                        continue;
                    }
                    this.aH.echoError("Could not match argument '%s'!", thisArg);
                }
                if (itemListenerId == null && itemScript != null) {
                    itemListenerId = itemScript;
                } else if (itemListenerId == null) {
                    itemScript = "Item_Listener_" + System.currentTimeMillis();
                }
                if (itemType == null || itemName == null || itemScript == null || itemListenerId == null) {
                    this.aH.echoError("Not enough arguments! Check syntax.");
                    return false;
                }
                List itemList = this.plugin.getSaves().getStringList("Players." + theEntry.getPlayer().getName() + ".Listeners.List");
                if (itemList.contains(itemListenerId)) {
                    this.aH.echoError("Already listening!");
                    return false;
                }
                this.playerListeners.put(theEntry.getPlayer().getName() + ":" + itemListenerId, new ItemListener());
                this.playerListeners.get(theEntry.getPlayer().getName() + ":" + itemListenerId).build(itemListenerId, theEntry.getPlayer(), new String[]{itemType, itemName, itemQty}, itemScript);
                itemList.add(itemListenerId);
                this.plugin.getSaves().set("Players." + theEntry.getPlayer().getName() + ".Listeners.List", (Object)itemList);
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void playerLogoff(PlayerQuitEvent event) {
        List listenerList = this.plugin.getSaves().getStringList("Players." + event.getPlayer().getName() + ".Listeners.List");
        if (!listenerList.isEmpty()) {
            for (String listener : listenerList) {
                if (this.playerListeners.get(event.getPlayer().getName() + ":" + listener) != null) {
                    this.aH.echoDebug(ChatColor.YELLOW + "// " + event.getPlayer().getName() + " has a LISTENER in progress. Saving " + listener + ".");
                    this.playerListeners.get(event.getPlayer().getName() + ":" + listener).save();
                    this.playerListeners.remove(event.getPlayer().getName() + ":" + listener);
                    continue;
                }
                List newList = this.plugin.getSaves().getStringList("Players." + event.getPlayer().getName() + ".Listeners.List");
                if (newList.contains(listener)) {
                    newList.remove(listener);
                }
                this.plugin.getSaves().set("Players." + event.getPlayer().getName() + ".Listeners.List", (Object)newList);
            }
        }
    }

    @EventHandler
    public void playerLogon(PlayerJoinEvent event) {
        List listenerList = this.plugin.getSaves().getStringList("Players." + event.getPlayer().getName() + ".Listeners.List");
        if (!listenerList.isEmpty()) {
            for (String listener : listenerList) {
                this.aH.echoDebug(ChatColor.YELLOW + "// " + event.getPlayer().getName() + " has a LISTENER in progress. Loading " + listener + ".");
                try {
                    switch (ListenerType.valueOf(this.plugin.getSaves().getString("Players." + event.getPlayer().getName() + ".Listeners.Saves." + listener + ".Listen Type"))) {
                        case KILL: {
                            this.playerListeners.put(event.getPlayer().getName() + ":" + listener, new KillListener());
                            this.playerListeners.get(event.getPlayer().getName() + ":" + listener).load(event.getPlayer(), listener);
                            break;
                        }
                        case BLOCK: {
                            this.playerListeners.put(event.getPlayer().getName() + ":" + listener, new BlockListener());
                            this.playerListeners.get(event.getPlayer().getName() + ":" + listener).load(event.getPlayer(), listener);
                            break;
                        }
                        case ITEM: {
                            this.playerListeners.put(event.getPlayer().getName() + ":" + listener, new ItemListener());
                            this.playerListeners.get(event.getPlayer().getName() + ":" + listener).load(event.getPlayer(), listener);
                        }
                    }
                }
                catch (Exception e) {
                    this.aH.echoError("Error loading player listener '%s'!", listener);
                }
                this.playerListeners.get(event.getPlayer().getName() + ":" + listener).report();
            }
        }
    }

    public void finish(Player thePlayer, String listenerId, String theScriptName, AbstractListener theListener) {
        List newList = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.List");
        if (newList.contains(listenerId)) {
            newList.remove(listenerId);
        }
        this.plugin.getSaves().set("Players." + thePlayer.getName() + ".Listeners.List", (Object)newList);
        this.plugin.getSaves().set("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId, null);
        ListenerFinishEvent event = new ListenerFinishEvent(thePlayer, theListener);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        List<String> theScript = sE.getScript(theScriptName + ".Script");
        if (theScript.isEmpty()) {
            return;
        }
        sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theScript, theScriptName), ScriptEngine.QueueType.TASK);
        this.playerListeners.remove(thePlayer.getName() + ":" + listenerId);
    }

    public void cancel(Player thePlayer, String listenerId) {
        List newList = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.List");
        if (newList.contains(listenerId)) {
            newList.remove(listenerId);
        }
        this.plugin.getSaves().set("Players." + thePlayer.getName() + ".Listeners.List", (Object)newList);
        ListenerCancelEvent event = new ListenerCancelEvent(thePlayer, listenerId);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.playerListeners.remove(thePlayer.getName() + ":" + listenerId);
    }

    static enum ListenerType {
        KILL,
        BLOCK,
        ITEM;

    }
}

