/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.commands.core.Direction;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.runnables.FourItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LookCommand
extends AbstractCommand {
    private Map<Integer, Integer> taskMap = new ConcurrentHashMap<Integer, Integer>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Integer duration = null;
        Direction direction = null;
        Location theLocation = null;
        Player theEntity = null;
        DenizenNPC theDenizen = theEntry.getDenizen();
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesDuration(thisArg)) {
                duration = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...look duration set to '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                theDenizen = this.aH.getNPCIDModifier(thisArg);
                if (theDenizen == null) continue;
                this.aH.echoDebug("...affecting '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesBookmark(thisArg)) {
                theLocation = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (theLocation == null) continue;
                this.aH.echoDebug("...drop location now at bookmark '%s'.", thisArg);
                continue;
            }
            for (Direction thisDirection : Direction.values()) {
                if (!thisArg.toUpperCase().equals(thisDirection.name())) continue;
                direction = Direction.valueOf(thisArg);
                this.aH.echoDebug("...set look direction '%s'.", thisArg);
            }
        }
        if (theDenizen == null) {
            this.aH.echoError("Seems this was sent from a TASK-type script. Must use NPCID:# to specify a Denizen NPC!");
            return false;
        }
        if (theLocation != null) {
            this.look((LivingEntity)theEntity, theDenizen, direction, duration, theLocation);
            return true;
        }
        if (theEntity == null) {
            theEntity = theEntry.getPlayer();
        }
        if (direction != null) {
            this.look((LivingEntity)theEntity, theDenizen, direction, duration, theLocation);
        }
        return true;
    }

    private void look(LivingEntity theEntity, DenizenNPC theDenizen, Direction lookDir, Integer duration, Location lookLoc) {
        Location restoreLocation = theDenizen.getEntity().getLocation();
        DenizenNPC restoreDenizen = theDenizen;
        Boolean restoreLookClose = theDenizen.isLookingClose();
        String lookWhere = "NOWHERE";
        if (lookDir != null) {
            lookWhere = lookDir.name();
        }
        if (lookWhere.equals("CLOSE")) {
            theDenizen.lookClose(true);
        } else if (lookWhere.equals("AWAY")) {
            theDenizen.lookClose(false);
        } else if (lookWhere.equals("LEFT")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = theDenizen.getLocation().getYaw() - 80.0f;
        } else if (lookWhere.equals("RIGHT")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = theDenizen.getLocation().getYaw() + 80.0f;
        } else if (lookWhere.equals("UP")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().pitch -= 60.0f;
            theDenizen.getHandle().az = theDenizen.getHandle().yaw;
        } else if (lookWhere.equals("DOWN")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().pitch += 40.0f;
            theDenizen.getHandle().az = theDenizen.getHandle().yaw;
        } else if (lookWhere.equals("BACK")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = theDenizen.getLocation().getYaw() - 180.0f;
        } else if (lookWhere.equals("SOUTH")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = 0.0f;
        } else if (lookWhere.equals("WEST")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = 90.0f;
        } else if (lookWhere.equals("NORTH")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = 180.0f;
        } else if (lookWhere.equals("EAST")) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = 270.0f;
        } else if (lookWhere.equals("AT")) {
            theDenizen.lookClose(false);
            this.faceEntity((Entity)theDenizen.getEntity(), (Entity)theEntity);
        } else if (lookLoc != null) {
            theDenizen.lookClose(false);
            theDenizen.getHandle().pitch = lookLoc.getPitch();
            theDenizen.getHandle().az = theDenizen.getHandle().yaw = lookLoc.getYaw();
        }
        if (duration != null) {
            if (this.taskMap.containsKey(theDenizen.getCitizensEntity().getId())) {
                try {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskMap.get(theDenizen.getId()).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.aH.echoDebug("Setting delayed task: RESET LOOK");
            this.taskMap.put(theDenizen.getCitizensEntity().getId(), this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new FourItemRunnable<DenizenNPC, Location, Boolean, Float>(restoreDenizen, restoreLocation, restoreLookClose, Float.valueOf(theDenizen.getLocation().getYaw())){

                @Override
                public void run(DenizenNPC denizen, Location location, Boolean lookClose, Float checkYaw) {
                    LookCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET LOOK.");
                    denizen.lookClose(lookClose);
                    denizen.getHandle().yaw = location.getYaw();
                    denizen.getHandle().pitch = location.getPitch();
                    denizen.getHandle().az = denizen.getHandle().yaw;
                }
            }, (long)(duration * 20)));
        }
    }

    private void faceEntity(Entity from, Entity at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getLocation().getX() - loc.getX();
        double yDiff = at.getLocation().getY() - loc.getY();
        double zDiff = at.getLocation().getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.acos(xDiff / distanceXZ) * 180.0 / Math.PI;
        double pitch = Math.acos(yDiff / distanceY) * 180.0 / Math.PI - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        EntityLiving handle = ((CraftLivingEntity)from).getHandle();
        handle.yaw = (float)yaw - 90.0f;
        handle.pitch = (float)pitch;
        handle.az = handle.yaw;
    }
}

