/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.runnables.TwoItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class PauseCommand
extends AbstractCommand {
    private Map<Integer, Integer> taskMap = new ConcurrentHashMap<Integer, Integer>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Integer duration = null;
        boolean waypoints = false;
        if (theEntry.arguments() != null) {
            for (String thisArg : theEntry.arguments()) {
                if (thisArg.contains("<")) {
                    thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                }
                if (this.aH.matchesDuration(thisArg)) {
                    duration = this.aH.getIntegerModifier(thisArg);
                    this.aH.echoDebug("...duration set to '%s'.", thisArg);
                    continue;
                }
                if (thisArg.toUpperCase().contains("WAYPOINTS")) {
                    waypoints = true;
                    this.aH.echoDebug("...affecting WAYPOINTS.", thisArg);
                    continue;
                }
                this.aH.echoError("...could not match '%s'!", thisArg);
            }
        }
        if (theEntry.getCommand().equalsIgnoreCase("RESUME")) {
            if (waypoints) {
                if (theEntry.getDenizen().getCitizensEntity().hasTrait(Waypoints.class)) {
                    ((Waypoints)theEntry.getDenizen().getCitizensEntity().getTrait(Waypoints.class)).getCurrentProvider().setPaused(false);
                }
            } else {
                theEntry.getDenizen().getCitizensEntity().getDefaultGoalController().setPaused(false);
            }
            return true;
        }
        if (waypoints) {
            if (theEntry.getDenizen().getCitizensEntity().hasTrait(Waypoints.class)) {
                ((Waypoints)theEntry.getDenizen().getCitizensEntity().getTrait(Waypoints.class)).getCurrentProvider().setPaused(true);
                theEntry.getDenizen().getNavigator().cancelNavigation();
            }
        } else {
            theEntry.getDenizen().getCitizensEntity().getDefaultGoalController().setPaused(true);
            theEntry.getDenizen().getNavigator().cancelNavigation();
        }
        if (duration != null) {
            if (this.taskMap.containsKey(theEntry.getDenizen().getCitizensEntity().getId())) {
                try {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskMap.get(theEntry.getDenizen().getCitizensEntity().getId()).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.aH.echoDebug("Setting delayed task: UNPAUSE GOAL SELECTOR.");
            this.taskMap.put(theEntry.getDenizen().getCitizensEntity().getId(), this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TwoItemRunnable<DenizenNPC, Boolean>(theEntry.getDenizen(), Boolean.valueOf(waypoints)){

                @Override
                public void run(DenizenNPC theNPC, Boolean waypoints) {
                    PauseCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: UNPAUSE GOAL SELECTOR for '%s'.", theNPC.getName());
                    if (waypoints.booleanValue()) {
                        if (theNPC.getCitizensEntity().hasTrait(Waypoints.class)) {
                            ((Waypoints)theNPC.getCitizensEntity().getTrait(Waypoints.class)).getCurrentProvider().setPaused(false);
                            theNPC.getNavigator().cancelNavigation();
                        }
                    } else {
                        theNPC.getCitizensEntity().getDefaultGoalController().setPaused(false);
                        theNPC.getNavigator().cancelNavigation();
                    }
                }
            }, (long)(duration * 20)));
        }
        return true;
    }
}

