/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;

public class RandomCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Integer numberOfEntries = null;
        if (theEntry.arguments() == null) {
            this.aH.echoError("No arguments! Usage: RANDOM [#]");
            return false;
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesInteger(thisArg)) {
                numberOfEntries = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...will randomly select from the next %s entries.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match argument '%'!", thisArg);
        }
        if (numberOfEntries == null) {
            this.aH.echoError("Required integer argument [#] not found. Check syntax.");
            return false;
        }
        List<Object> currentQueue = new ArrayList();
        currentQueue = theEntry.getPlayer() != null ? this.plugin.getScriptEngine().getPlayerQueue(theEntry.getPlayer(), theEntry.sendingQueue()) : this.plugin.getScriptEngine().getDenizenQueue(theEntry.getDenizen(), theEntry.sendingQueue());
        if (currentQueue.size() < numberOfEntries) {
            this.aH.echoError("Invalid Size! RANDOM [#] must not be larger than the script!");
            return false;
        }
        Random random = new Random();
        int selected = random.nextInt(numberOfEntries);
        ScriptEntry sEtoKeep = null;
        this.aH.echoDebug("...random number generator selected '%s'", String.valueOf(selected + 1));
        for (int x = 0; x < numberOfEntries; ++x) {
            if (x != selected) {
                this.aH.echoDebug("...removing '%s'", ((ScriptEntry)currentQueue.get(0)).getCommand());
                currentQueue.remove(0);
                continue;
            }
            this.aH.echoDebug("...selected '%s'", ((ScriptEntry)currentQueue.get(0)).getCommand() + ": " + ((ScriptEntry)currentQueue.get(0)).arguments());
            sEtoKeep = (ScriptEntry)currentQueue.get(0);
            currentQueue.remove(0);
        }
        currentQueue.add(0, sEtoKeep);
        if (theEntry.getPlayer() != null) {
            this.plugin.getScriptEngine().replacePlayerQue(theEntry.getPlayer(), currentQueue, theEntry.sendingQueue());
        } else {
            this.plugin.getScriptEngine().replaceDenizenQue(theEntry.getDenizen(), currentQueue);
        }
        return true;
    }
}

