/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.List;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.runnables.FourItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class RunTaskCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        String theScriptName = null;
        int secs = -1;
        DenizenNPC executer = theEntry.getDenizen();
        if (theEntry.arguments() == null) {
            this.aH.echoDebug("...No arguments!");
            return false;
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesScript(thisArg)) {
                theScriptName = this.aH.getStringModifier(thisArg);
                this.aH.echoDebug("...running task script '" + theScriptName + "'.");
                continue;
            }
            if (thisArg.toUpperCase().contains("DELAY:")) {
                secs = this.aH.getIntegerModifier(thisArg);
                continue;
            }
            if (this.aH.matchesNPCID(thisArg)) {
                executer = this.aH.getNPCIDModifier(thisArg);
                continue;
            }
            this.aH.echoError("Could not match argument '%s'!", thisArg);
        }
        if (theScriptName == null) {
            this.aH.echoDebug("...No task specified!");
            return false;
        }
        if (theEntry.getCommand().equalsIgnoreCase("CANCELTASK")) {
            if (theEntry.getPlayer().hasMetadata(theScriptName)) {
                int tid = ((MetadataValue)theEntry.getPlayer().getMetadata(theScriptName).get(0)).asInt();
                if (tid > 0) {
                    this.plugin.getServer().getScheduler().cancelTask(tid);
                    theEntry.getPlayer().removeMetadata(theScriptName, (Plugin)this.plugin);
                }
            } else {
                this.aH.echoDebug("...Pending task " + theScriptName + " not found for this player");
                return false;
            }
            return true;
        }
        if (executer == null) {
            this.aH.echoDebug("...Invalid NPC specified!");
            return false;
        }
        if (!this.plugin.getScriptEngine().helper.checkCooldown(theEntry.getPlayer(), theScriptName)) {
            this.aH.echoDebug("...Did not run " + theScriptName + ", is is currently not cooled down.");
            return true;
        }
        if (secs > 0) {
            int id = this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new FourItemRunnable<Player, String, DenizenNPC, Integer>(theEntry.getPlayer(), theScriptName, executer, Integer.valueOf(0)){

                @Override
                public void run(Player player, String theScriptName, DenizenNPC denizen, Integer oldStep) {
                    ScriptHelper sE;
                    List<String> theScript;
                    int tid;
                    if (player.hasMetadata(theScriptName) && (tid = ((MetadataValue)player.getMetadata(theScriptName).get(0)).asInt()) > 0) {
                        RunTaskCommand.this.plugin.getServer().getScheduler().cancelTask(tid);
                        player.removeMetadata(theScriptName, (Plugin)RunTaskCommand.this.plugin);
                    }
                    if ((theScript = (sE = RunTaskCommand.this.plugin.getScriptEngine().helper).getScript(theScriptName + ".Script")).isEmpty()) {
                        return;
                    }
                    sE.queueScriptEntries(player, sE.buildScriptEntries(player, denizen, theScript, theScriptName, 1), ScriptEngine.QueueType.TASK);
                    player.removeMetadata(theScriptName, (Plugin)RunTaskCommand.this.plugin);
                }
            }, (long)(secs * 20));
            theEntry.getPlayer().setMetadata(theScriptName, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)id));
            return true;
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        List<String> theScript = sE.getScript(theScriptName + ".Script");
        if (theScript.isEmpty()) {
            return false;
        }
        sE.queueScriptEntries(theEntry.getPlayer(), sE.buildScriptEntries(theEntry.getPlayer(), executer, theScript, theScriptName, 1), ScriptEngine.QueueType.TASK);
        return true;
    }
}

