/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Random;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpawnCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        EntityType theEntity = null;
        Integer theAmount = null;
        Location theLocation = null;
        Integer theSpread = null;
        PotionEffect theEffect = null;
        Boolean hasFlag = false;
        Boolean isTame = false;
        Boolean isBaby = false;
        Boolean isPowered = false;
        Boolean isAngry = false;
        Boolean isSaddled = false;
        Boolean isSheared = false;
        String hasColor = null;
        String hasProfession = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: SPAWN [ENTITY_TYPE] (QTY:#) (BOOKMARK:LocationBookmark)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.plugin.utilities.isEntity(thisArg)) {
                theEntity = EntityType.valueOf((String)thisArg.toUpperCase());
                this.aH.echoDebug("...entity to spawn set to '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesInteger(thisArg)) {
                theAmount = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...quantity to spawn: '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesQuantity(thisArg)) {
                theAmount = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...quantity to spawn: '%s'.", thisArg);
                continue;
            }
            if (thisArg.matches("(?:SPREAD|spread|Spread)(:)(\\d+)")) {
                theSpread = Integer.valueOf(thisArg.split(":", 2)[1]);
                continue;
            }
            if (thisArg.toUpperCase().contains("EFFECT:")) {
                try {
                    int theAmplifier = 1;
                    if (thisArg.split(":", 2)[1].split(" ").length == 2) {
                        theAmplifier = Integer.valueOf(thisArg.split(":", 2)[1].split(" ")[1]);
                    }
                    theEffect = new PotionEffect(PotionEffectType.getByName((String)thisArg.split(":", 2)[1].split(" ")[0]), Integer.MAX_VALUE, theAmplifier);
                    this.aH.echoDebug("...spawning with effect: '%s'.", thisArg);
                }
                catch (Exception e) {
                    this.aH.echoError("Invalid Potion_Type! '%s'.", thisArg);
                }
                continue;
            }
            if (thisArg.toUpperCase().contains("OPTION:")) {
                String thisFlag = thisArg.split(":", 2)[1];
                hasFlag = true;
                if (thisFlag.toUpperCase().equals("BABY")) {
                    isBaby = true;
                }
                if (thisFlag.toUpperCase().equals("ANGRY")) {
                    isAngry = true;
                }
                if (thisFlag.toUpperCase().equals("POWERED")) {
                    isPowered = true;
                }
                if (thisFlag.toUpperCase().equals("SHEARED")) {
                    isSheared = true;
                }
                if (thisFlag.toUpperCase().equals("TAME")) {
                    isTame = true;
                }
                if (thisFlag.toUpperCase().equals("SADDLED")) {
                    isSaddled = true;
                }
                if (thisFlag.toUpperCase().contains("COLORED ")) {
                    hasColor = thisFlag.split(" ")[1];
                }
                if (thisFlag.toUpperCase().contains("PROFESSION ")) {
                    hasProfession = thisFlag.split(" ")[1];
                }
                this.aH.echoDebug("...setting: '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesBookmark(thisArg)) {
                theLocation = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (theLocation == null) continue;
                this.aH.echoDebug("...using location: '%s'", thisArg);
                continue;
            }
            this.aH.echoError("Could not match argument '%s'.", thisArg);
        }
        if (theAmount == null) {
            theAmount = 1;
        }
        if (theLocation == null && theEntry.getDenizen() != null) {
            theLocation = theEntry.getDenizen().getLocation();
        }
        if (theLocation == null) {
            theLocation = theEntry.getPlayer().getLocation();
        }
        if (theLocation != null && theAmount != null && theEntity != null) {
            for (int x = 0; x < theAmount; ++x) {
                Location spawnLoc = theLocation.clone();
                if (theSpread != null) {
                    Random randomGenerator = new Random();
                    int i = 0;
                    boolean ok = false;
                    do {
                        int randomX = randomGenerator.nextInt(theSpread * 2);
                        int randomZ = randomGenerator.nextInt(theSpread * 2);
                        randomX = -theSpread.intValue();
                        randomZ = -theSpread.intValue();
                        ++i;
                        if (theLocation.getWorld().getBlockAt(theLocation.getBlockX() + randomX, theLocation.getBlockY() + 1, theLocation.getBlockZ() + randomZ).getTypeId() != 0) continue;
                        spawnLoc.add((double)randomX, 0.0, (double)randomZ);
                        ok = true;
                    } while (i < theSpread * theSpread && !ok);
                }
                Entity spawnedEntity = null;
                if (theEntity.equals((Object)EntityType.BOAT)) {
                    spawnLoc.getWorld().spawn(spawnLoc, Boat.class);
                }
                if (theEntity.equals((Object)EntityType.MINECART)) {
                    spawnLoc.getWorld().spawn(spawnLoc, Minecart.class);
                } else {
                    spawnedEntity = spawnLoc.getWorld().spawnEntity(spawnLoc, theEntity);
                }
                if (theEffect != null) {
                    ((LivingEntity)spawnedEntity).addPotionEffect(theEffect);
                }
                if (!hasFlag.booleanValue()) continue;
                try {
                    if (isBaby.booleanValue() && spawnedEntity instanceof Ageable) {
                        ((Ageable)spawnedEntity).setBaby();
                    }
                    if (isTame.booleanValue() && spawnedEntity instanceof Tameable) {
                        ((Tameable)spawnedEntity).setTamed(true);
                    }
                    if (isAngry.booleanValue() && spawnedEntity instanceof Wolf) {
                        ((Wolf)spawnedEntity).setAngry(true);
                    }
                    if (isAngry.booleanValue() && spawnedEntity instanceof PigZombie) {
                        ((PigZombie)spawnedEntity).setAngry(true);
                    }
                    if (isPowered.booleanValue() && spawnedEntity instanceof Creeper) {
                        ((Creeper)spawnedEntity).setPowered(true);
                    }
                    if (isSaddled.booleanValue() && spawnedEntity instanceof Pig) {
                        ((Pig)spawnedEntity).setSaddle(true);
                    }
                    if (isSheared.booleanValue() && spawnedEntity instanceof Sheep) {
                        ((Sheep)spawnedEntity).setSheared(true);
                    }
                    if (hasColor != null && spawnedEntity instanceof Sheep) {
                        ((Sheep)spawnedEntity).setColor(DyeColor.valueOf((String)hasColor.toUpperCase()));
                    }
                    if (hasProfession == null || !(spawnedEntity instanceof Villager)) continue;
                    ((Villager)spawnedEntity).setProfession(Villager.Profession.valueOf((String)hasProfession.toUpperCase()));
                    continue;
                }
                catch (Exception e) {
                    throw new CommandException("Problem setting flag!");
                }
            }
            return true;
        }
        return false;
    }
}

