/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.runnables.OneItemRunnable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import net.minecraft.server.v1_4_R1.Block;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_4_R1.CraftWorld;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<String, Integer> taskMap = new ConcurrentHashMap<String, Integer>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        org.bukkit.World theWorld;
        Location interactLocation = null;
        Integer duration = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: SWITCH [BOOKMARK:block] (DURATION:#)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesDuration(thisArg)) {
                duration = Integer.valueOf(thisArg.split(":")[1]);
                continue;
            }
            if (this.aH.matchesBookmark(thisArg)) {
                interactLocation = this.aH.getBlockBookmarkModifier(thisArg, theEntry.getDenizen());
                if (interactLocation != null) {
                    this.aH.echoDebug("...switch location now at bookmark '%s'", thisArg);
                    continue;
                }
                this.aH.echoDebug("... could not find block bookmark: '%s'", thisArg);
                interactLocation = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (interactLocation == null) continue;
                this.aH.echoDebug("...Found location bookmark matching '%s' using that.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'.", thisArg);
        }
        if (interactLocation == null) {
            this.aH.echoError("No interact location specified! Must use BOOKMARK:block to specify a location.");
            return false;
        }
        if (interactLocation.getBlock().getType() == Material.LEVER) {
            theWorld = interactLocation.getWorld();
            Block.LEVER.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
        } else if (interactLocation.getBlock().getType() == Material.STONE_BUTTON) {
            theWorld = interactLocation.getWorld();
            Block.STONE_BUTTON.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
        } else if (interactLocation.getBlock().getType() == Material.STONE_PLATE) {
            theWorld = interactLocation.getWorld();
            Block.STONE_PLATE.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
        } else if (interactLocation.getBlock().getType() == Material.WOOD_PLATE) {
            theWorld = interactLocation.getWorld();
            Block.WOOD_PLATE.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
        } else {
            this.aH.echoError("Unusable block at this location! Found " + interactLocation.getBlock().getType().name() + ".");
            return false;
        }
        if (duration != null) {
            if (this.taskMap.containsKey(theEntry.getDenizen().getName())) {
                try {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskMap.get(theEntry.getDenizen().getName()).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.aH.echoDebug("Setting delayed task: RESET LOOK");
            this.taskMap.put(theEntry.getDenizen().getName(), this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new OneItemRunnable<Location>(interactLocation){

                @Override
                public void run(Location interactLocation) {
                    SwitchCommand.this.aH.echoDebug(ChatColor.YELLOW + "//DELAYED//" + ChatColor.WHITE + " Running delayed task: RESET LOOK.");
                    if (interactLocation != null) {
                        if (interactLocation.getBlock().getType() == Material.LEVER) {
                            org.bukkit.World theWorld = interactLocation.getWorld();
                            Block.LEVER.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                            return;
                        }
                        if (interactLocation.getBlock().getType() == Material.STONE_BUTTON) {
                            org.bukkit.World theWorld = interactLocation.getWorld();
                            Block.STONE_BUTTON.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                            return;
                        }
                        if (interactLocation.getBlock().getType() == Material.STONE_PLATE) {
                            org.bukkit.World theWorld = interactLocation.getWorld();
                            Block.STONE_PLATE.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                            return;
                        }
                        if (interactLocation.getBlock().getType() == Material.WOOD_PLATE) {
                            org.bukkit.World theWorld = interactLocation.getWorld();
                            Block.WOOD_PLATE.interact((World)((CraftWorld)theWorld).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                            return;
                        }
                        if (SwitchCommand.this.plugin.debugMode.booleanValue()) {
                            SwitchCommand.this.plugin.getLogger().log(Level.INFO, "...unusable block at this location! Found " + interactLocation.getBlock().getType().name() + ".");
                        }
                    }
                }
            }, (long)(duration * 20)));
        }
        return true;
    }
}

