/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.logging.Level;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TakeCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Enum takeType = null;
        int theAmount = 1;
        ItemStack theItem = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("...Usage: TAKE [ITEM_IN_HAND|EXP|MONEY|#(:#)|MATERIAL_TYPE(:#)] (QTY:#)");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesQuantity(thisArg)) {
                theAmount = this.aH.getIntegerModifier(thisArg);
                this.aH.echoDebug("...set quantity to '%s'.", thisArg);
                continue;
            }
            if (thisArg.toUpperCase().contains("MONEY")) {
                takeType = TakeType.MONEY;
                this.aH.echoDebug("...taking MONEY.");
                continue;
            }
            if (thisArg.toUpperCase().contains("XP") || thisArg.toUpperCase().contains("EXP")) {
                takeType = TakeType.EXP;
                this.aH.echoDebug("...taking EXP.");
                continue;
            }
            if (thisArg.toUpperCase().contains("ITEMINHAND") || thisArg.toUpperCase().contains("ITEM_IN_HAND")) {
                takeType = TakeType.ITEMINHAND;
                this.aH.echoDebug("...matched argument to 'Item in hand'.");
                continue;
            }
            if (this.aH.matchesItem(thisArg)) {
                theItem = this.aH.getItemModifier(thisArg);
                takeType = TakeType.ITEM;
                if (theItem == null) continue;
                this.aH.echoDebug("...set item to be taken to '%s'.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        if (takeType != null) {
            switch (1.$SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType[takeType.ordinal()]) {
                case 1: {
                    if (this.plugin.economy != null) {
                        double playerBalance = this.plugin.economy.getBalance(theEntry.getPlayer().getName());
                        double doubleAmount = theAmount;
                        if (doubleAmount > playerBalance) {
                            this.aH.echoDebug("...player did not have enough money to take. New amount is balance of the Player's account. To avoid this situation, use a MONEY requirement.");
                            doubleAmount = playerBalance;
                        }
                        this.plugin.economy.withdrawPlayer(theEntry.getPlayer().getName(), doubleAmount);
                        break;
                    }
                    this.aH.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    break;
                }
                case 2: {
                    int inHandAmt = theEntry.getPlayer().getItemInHand().getAmount();
                    ItemStack newHandItem = new ItemStack(Material.AIR);
                    if (theAmount > inHandAmt) {
                        this.aH.echoDebug("...player did not have enough of the item in hand, so Denizen just took as many as it could. To avoid this situation, use a HOLDING requirement.");
                        theEntry.getPlayer().setItemInHand(newHandItem);
                        break;
                    }
                    if (theAmount == inHandAmt) {
                        theEntry.getPlayer().setItemInHand(newHandItem);
                        break;
                    }
                    newHandItem = new ItemStack(theEntry.getPlayer().getItemInHand().getType(), inHandAmt - theAmount, (short)theEntry.getPlayer().getItemInHand().getData().getData());
                    theEntry.getPlayer().setItemInHand(newHandItem);
                    theEntry.getPlayer().updateInventory();
                    break;
                }
                case 3: {
                    theItem.setAmount(theAmount);
                    if (theEntry.getPlayer().getInventory().removeItem(new ItemStack[]{theItem}).isEmpty() || !this.plugin.debugMode.booleanValue()) break;
                    this.plugin.getLogger().log(Level.INFO, "...player did not have enough of the item specified, so Denizen just took as many as it could. To avoid this situation, use an ITEM requirement.");
                }
            }
            return true;
        }
        if (this.plugin.debugMode.booleanValue()) {
            throw new CommandException("...Usage: TAKE [MONEY|ITEMINHAND|#(:#)|MATERIAL_TYPE(:#)] (QTY:#)");
        }
        return false;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType;

        static {
            $SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType = new int[TakeType.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType[TakeType.MONEY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType[TakeType.ITEMINHAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$commands$core$TakeCommand$TakeType[TakeType.ITEM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum TakeType {
        ITEM,
        ITEMINHAND,
        MONEY,
        EXP;

    }
}

