/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.entity.Player;

public class TalkCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        DenizenNPC theDenizen = null;
        String theMessage = null;
        Boolean noPlayer = false;
        Player thePlayer = null;
        if (theEntry.arguments() == null) {
            throw new CommandException("No talk text!");
        }
        if (theEntry.arguments().length > 3) {
            this.aH.echoError("Woah! Lots of arguments detected in " + theEntry.getCommand() + ".  Perhaps you are failing to enclose your Talk Text in quotes?  Example usage: CHAT 'Hello world!'");
        } else {
            if (theEntry.getPlayer() == null) {
                noPlayer = true;
            }
            for (String thisArg : theEntry.arguments()) {
                if (thisArg.contains("<")) {
                    thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
                }
                if (thisArg.toUpperCase().equalsIgnoreCase("NOPLAYER")) {
                    this.aH.echoError("...will not target Player.");
                    noPlayer = true;
                    continue;
                }
                if (thisArg.toUpperCase().equalsIgnoreCase("ASPLAYER")) {
                    this.aH.echoError("...will make the Player talk.");
                    noPlayer = true;
                    continue;
                }
                if (this.aH.matchesNPCID(thisArg)) {
                    theDenizen = this.aH.getNPCIDModifier(thisArg);
                    if (theDenizen == null) continue;
                    this.aH.echoDebug("...specified '%s'.", thisArg);
                    continue;
                }
                this.aH.echoDebug("...text: '%s'", thisArg);
                theMessage = thisArg;
            }
        }
        if (theEntry.getTexts()[0] != null) {
            theMessage = theMessage.replace("<*>", theEntry.getTexts()[0]);
        }
        if (theDenizen == null && theEntry.getDenizen() != null) {
            theDenizen = theEntry.getDenizen();
        }
        if (!noPlayer.booleanValue()) {
            thePlayer = theEntry.getPlayer();
        }
        if (theDenizen == null && !theEntry.getCommand().equals("NARRATE")) {
            this.aH.echoError("Seems this was sent from a TASK-type script. Must specify NPCID:#!");
            return false;
        }
        if (theEntry.getCommand().equals("NARRATE") && theEntry.sendingQueue() == ScriptEngine.QueueType.ACTIVITY) {
            this.aH.echoError("NARRATE is not applicable to an ACTIVITY Task.");
            return false;
        }
        if (theMessage != null && theDenizen != null) {
            theDenizen.talk(SpeechEngine.TalkType.valueOf(theEntry.getCommand()), thePlayer, theMessage);
            return true;
        }
        if (theMessage != null && theEntry.getCommand().equals("NARRATE")) {
            this.plugin.getSpeechEngine().talk(null, thePlayer, theMessage, SpeechEngine.TalkType.NARRATE);
            return true;
        }
        return false;
    }
}

