/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.Location;

public class TeleportCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Location teleportLocation = null;
        Boolean teleportPlayer = true;
        if (theEntry.arguments() == null) {
            throw new CommandException("...not enough arguments! Usage: TELEPORT '[Location Bookmark]|'[Denizen Name]:[Location Bookmark]'");
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (thisArg.toUpperCase().contains("DENIZEN")) {
                teleportPlayer = false;
                this.aH.echoDebug("...now teleporting DENIZEN instead of PLAYER.", thisArg);
                continue;
            }
            if (this.aH.matchesBookmark(thisArg)) {
                teleportLocation = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (teleportLocation == null) continue;
                this.aH.echoDebug("...teleport location now at '%s'.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        if (teleportLocation != null) {
            if (teleportPlayer.booleanValue()) {
                theEntry.getPlayer().teleport(teleportLocation);
            } else {
                theEntry.getDenizen().getEntity().teleport(teleportLocation);
            }
            return true;
        }
        return false;
    }
}

