/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.ArrayList;
import java.util.logging.Level;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import org.bukkit.entity.Player;

public class WaitCommand
extends AbstractCommand {
    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        if (theEntry.getDelayedTime() > theEntry.getInitiatedTime()) {
            this.aH.echoDebug("...and we've waited. Resuming.");
            return true;
        }
        ScriptEngine.QueueType queueToHold = theEntry.sendingQueue();
        Player thePlayer = theEntry.getPlayer();
        theEntry.setInstant();
        Long theDelay = null;
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (this.aH.matchesInteger(thisArg)) {
                if (this.plugin.debugMode.booleanValue()) {
                    this.plugin.getLogger().log(Level.INFO, "...setting delay.");
                }
                theDelay = Long.valueOf(thisArg) * 1000L;
            }
            if (!thisArg.toUpperCase().contains("QUEUETYPE:")) continue;
            this.aH.echoDebug("...setting QueueType.");
            try {
                queueToHold = ScriptEngine.QueueType.valueOf(thisArg.split(":")[1]);
            }
            catch (Throwable e) {
                throw new CommandException("Invalid QUEUETYPE.");
            }
        }
        ArrayList<ScriptEntry> theList = new ArrayList<ScriptEntry>();
        ScriptEntry newEntry = null;
        try {
            newEntry = new ScriptEntry(theEntry.getCommand(), theEntry.arguments(), theEntry.getPlayer(), theEntry.getScript());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newEntry.setDelay(System.currentTimeMillis() + theDelay);
        theList.add(newEntry);
        if (queueToHold == ScriptEngine.QueueType.TASK) {
            this.aH.echoDebug("...now holding Task Queue.");
            this.plugin.getScriptEngine().injectToQueue(thePlayer, theList, ScriptEngine.QueueType.TASK, 0);
            return true;
        }
        if (queueToHold == ScriptEngine.QueueType.TRIGGER) {
            this.aH.echoDebug("...now holding Trigger Queue.");
            this.plugin.getScriptEngine().injectToQueue(thePlayer, theList, ScriptEngine.QueueType.TRIGGER, 0);
            return true;
        }
        throw new CommandException("...Usage: WAIT [# OF SECONDS]");
    }
}

