/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.commands.AbstractCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class WalkToCommand
extends AbstractCommand {
    private Map<DenizenNPC, Location> returns = new HashMap<DenizenNPC, Location>();

    @Override
    public boolean execute(ScriptEntry theEntry) throws CommandException {
        Location walkLocation = null;
        boolean returning = false;
        Float Speed = null;
        if (theEntry.getCommand().equalsIgnoreCase("return")) {
            if (this.returns.containsKey(theEntry.getDenizen())) {
                walkLocation = this.returns.get(theEntry.getDenizen());
                returning = true;
            } else {
                this.aH.echoDebug("Return location not found for " + theEntry.getDenizen().getName());
                return false;
            }
        }
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.contains("<")) {
                thisArg = this.aH.fillReplaceables(theEntry.getPlayer(), theEntry.getDenizen(), thisArg, false);
            }
            if (!thisArg.toUpperCase().contains("SPEED:")) continue;
            try {
                Speed = Float.valueOf(this.aH.getStringModifier(thisArg));
                this.aH.echoDebug("... speed set to " + Speed);
            }
            catch (Exception e) {
                this.aH.echoDebug("... Invalid Speed!");
            }
        }
        if (theEntry.getCommand().equalsIgnoreCase("walkto")) {
            walkLocation = this.handleWalkTo(theEntry);
        } else if (theEntry.getCommand().equalsIgnoreCase("walk")) {
            walkLocation = this.handleWalk(theEntry);
        }
        if (walkLocation != null) {
            double dist = theEntry.getDenizen().getLocation().distance(walkLocation);
            ((Waypoints)theEntry.getDenizen().getCitizensEntity().getTrait(Waypoints.class)).getCurrentProvider().setPaused(true);
            theEntry.getDenizen().getNavigator().cancelNavigation();
            theEntry.getDenizen().getCitizensEntity().getNavigator().setTarget(walkLocation);
            if ((double)theEntry.getDenizen().getNavigator().getDefaultParameters().range() < dist) {
                theEntry.getDenizen().getNavigator().getLocalParameters().range((float)(dist + 3.0));
            }
            if (Speed != null) {
                theEntry.getDenizen().getCitizensEntity().getNavigator().getDefaultParameters().speedModifier(Speed.floatValue());
            }
            if (returning) {
                ((Waypoints)theEntry.getDenizen().getCitizensEntity().getTrait(Waypoints.class)).getCurrentProvider().setPaused(false);
            } else {
                this.returns.put(theEntry.getDenizen(), walkLocation);
            }
            return true;
        }
        this.aH.echoDebug("...No location!");
        return false;
    }

    private Location handleWalkTo(ScriptEntry theEntry) {
        Location out = null;
        for (String thisArg : theEntry.arguments()) {
            if (thisArg.equalsIgnoreCase("PLAYER")) {
                if (theEntry.getPlayer() == null) {
                    return null;
                }
                out = theEntry.getPlayer().getLocation();
                Vector victor = out.getDirection();
                out.subtract(victor);
                this.aH.echoDebug("...walk location now at '%s'.", theEntry.getPlayer().getName());
            }
            if (this.aH.matchesBookmark(thisArg)) {
                out = this.aH.getBookmarkModifier(thisArg, theEntry.getDenizen());
                if (out == null) continue;
                this.aH.echoDebug("...walk location now at '%s'.", thisArg);
                continue;
            }
            this.aH.echoError("...unable to match '%s'!", thisArg);
        }
        return out;
    }

    private Location handleWalk(ScriptEntry theEntry) {
        Location out = theEntry.getDenizen().getLocation();
        for (String thisArg : theEntry.arguments()) {
            double amt;
            if (thisArg.toUpperCase().contains("FORWARD:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                Vector victor = theEntry.getDenizen().getLocation().getDirection();
                victor.multiply(amt);
                this.aH.echoDebug("... offset forward " + amt);
                out.add(victor);
            }
            if (thisArg.toUpperCase().contains("NORTH:") || thisArg.toUpperCase().contains("Z:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                out.add(0.0, 0.0, amt);
                this.aH.echoDebug("... offset z " + amt);
            }
            if (thisArg.toUpperCase().contains("SOUTH:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                out.add(0.0, 0.0, -amt);
                this.aH.echoDebug("... offset -z " + amt);
            }
            if (thisArg.toUpperCase().contains("WEST:") || thisArg.toUpperCase().contains("X:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                out.add(amt, 0.0, 0.0);
                this.aH.echoDebug("... offset x " + amt);
            }
            if (thisArg.toUpperCase().contains("EAST:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                out.add(-amt, 0.0, 0.0);
                this.aH.echoDebug("... offset -x " + amt);
            }
            if (thisArg.toUpperCase().contains("UP:") || thisArg.toUpperCase().contains("Y:")) {
                amt = Double.valueOf(this.aH.getStringModifier(thisArg));
                out.add(0.0, amt, 0.0);
                this.aH.echoDebug("... offset y " + amt);
            }
            if (!thisArg.toUpperCase().contains("DOWN:")) continue;
            amt = Double.valueOf(this.aH.getStringModifier(thisArg));
            out.add(0.0, -amt, 0.0);
            this.aH.echoDebug("... offset -y " + amt);
        }
        return out;
    }
}

