/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.commands.core.ListenCommand;
import net.aufdemrand.denizen.listeners.AbstractListener;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class BlockListener
extends AbstractListener {
    BlockType type;
    List<String> blocks;
    Integer quantity;
    String listenerId;
    Integer currentBlocks = 0;
    List<Location> blocksBroken = new ArrayList<Location>();
    List<Integer> itemsCollected = new ArrayList<Integer>();
    List<Location> blocksPlaced = new ArrayList<Location>();

    @Override
    public void build(String listenerId, Player thePlayer, String[] args, String scriptName) {
        this.listenerId = listenerId;
        this.thePlayer = thePlayer;
        this.scriptName = scriptName;
        try {
            this.type = BlockType.valueOf(args[0]);
            this.blocks = Arrays.asList(args[1].toUpperCase().split(","));
            this.quantity = Integer.valueOf(args[2]);
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to build BLOCK listener for '%s'!", thePlayer.getName());
            if (this.plugin.debugMode.booleanValue()) {
                e.printStackTrace();
            }
            this.cancel();
        }
    }

    @EventHandler
    public void listenBreak(BlockBreakEvent event) {
        if (this.type == BlockType.BREAK && event.getPlayer() == this.thePlayer && (this.blocks.contains(event.getBlock().getType().toString()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId())))) {
            if (this.blocksBroken.contains(event.getBlock().getLocation())) {
                return;
            }
            this.blocksBroken.add(event.getBlock().getLocation());
            Integer n = this.currentBlocks;
            Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
            this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " broke a " + event.getBlock().getType().toString() + ".");
            this.complete(false);
        }
    }

    @EventHandler
    public void listenCollect(PlayerPickupItemEvent event) {
        if (this.type == BlockType.COLLECT && event.getPlayer() == this.thePlayer && (this.blocks.contains(event.getItem().getItemStack().getType().toString()) || this.blocks.contains(String.valueOf(event.getItem().getItemStack().getTypeId())))) {
            if (this.itemsCollected.contains(event.getItem().getEntityId())) {
                return;
            }
            this.itemsCollected.add(event.getItem().getEntityId());
            Integer n = this.currentBlocks;
            Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
            this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " collected a " + event.getItem().getItemStack().getType().toString() + ".");
            this.complete(false);
        }
    }

    @EventHandler
    public void listenPlace(BlockPlaceEvent event) {
        if (this.type == BlockType.BUILD && event.getPlayer() == this.thePlayer && (this.blocks.contains(event.getBlock().getType().toString()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId())))) {
            if (this.blocksPlaced.contains(event.getBlock().getLocation())) {
                return;
            }
            this.blocksPlaced.add(event.getBlock().getLocation());
            Integer n = this.currentBlocks;
            Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
            this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " placed a " + event.getBlock().getType().toString() + ".");
            this.complete(false);
        }
    }

    @Override
    public void complete(boolean forceable) {
        if (this.quantity == this.currentBlocks || forceable) {
            PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
            BlockBreakEvent.getHandlerList().unregister((Listener)this);
            BlockPlaceEvent.getHandlerList().unregister((Listener)this);
            this.plugin.getCommandRegistry().getCommand(ListenCommand.class).finish(this.thePlayer, this.listenerId, this.scriptName, this);
        }
    }

    @Override
    public void cancel() {
        PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
        BlockBreakEvent.getHandlerList().unregister((Listener)this);
        BlockPlaceEvent.getHandlerList().unregister((Listener)this);
        this.plugin.getCommandRegistry().getCommand(ListenCommand.class).cancel(this.thePlayer, this.listenerId);
    }

    @Override
    public void save() {
        try {
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Listen Type", (Object)"BLOCK");
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Script", (Object)this.scriptName);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Type", (Object)this.type.toString());
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Blocks", this.blocks);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Quantity", (Object)this.quantity);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Current Blocks", (Object)this.currentBlocks);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to save BLOCK listener for '%s'!", this.thePlayer.getName());
        }
    }

    @Override
    public void load(Player thePlayer, String listenerId) {
        try {
            this.thePlayer = thePlayer;
            this.listenerId = listenerId;
            this.scriptName = this.plugin.getSaves().getString("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Script");
            this.type = BlockType.valueOf(this.plugin.getSaves().getString("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Type"));
            this.blocks = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Blocks");
            this.quantity = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Quantity");
            this.currentBlocks = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Current Blocks");
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to load BLOCK listener for '%s'!", thePlayer.getName());
            this.cancel();
        }
    }

    @Override
    public void report() {
    }

    static enum BlockType {
        BUILD,
        COLLECT,
        BREAK;

    }
}

