/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.commands.core.ListenCommand;
import net.aufdemrand.denizen.listeners.AbstractListener;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;

public class ItemListener
extends AbstractListener {
    ItemType type;
    List<String> items;
    int quantity = 0;
    String listenerId;
    int currentItems = 0;
    List<Integer> itemsCrafted = new ArrayList<Integer>();
    List<Integer> itemsSmelted = new ArrayList<Integer>();
    List<EntityType> itemsFished = new ArrayList<EntityType>();

    @Override
    public void build(String listenerId, Player thePlayer, String[] args, String scriptName) {
        this.listenerId = listenerId;
        this.thePlayer = thePlayer;
        this.scriptName = scriptName;
        try {
            this.type = ItemType.valueOf(args[0]);
            this.items = new ArrayList<String>(Arrays.asList(args[1].toUpperCase().split(",")));
            this.quantity = Integer.valueOf(args[2]);
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to build ITEM listener for '%s'!", thePlayer.getName());
            e.printStackTrace();
            this.cancel();
        }
    }

    @EventHandler
    public void listenCraft(CraftItemEvent event) {
        if (this.type == ItemType.CRAFT && event.getWhoClicked() == this.thePlayer && (this.items.contains(event.getCurrentItem().getType().toString()) || this.items.contains(String.valueOf(event.getCurrentItem().getTypeId())))) {
            if (this.itemsCrafted.contains(event.getCurrentItem().getTypeId())) {
                return;
            }
            this.itemsCrafted.add(event.getCurrentItem().getTypeId());
            ++this.currentItems;
            this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " crafted a " + event.getCurrentItem().getType().toString() + ".");
            this.complete(false);
        }
    }

    @EventHandler
    public void listenSmelt(FurnaceSmeltEvent event) {
        if (this.type == ItemType.SMELT) {
            InventoryClickEvent e = (InventoryClickEvent)this.thePlayer;
            if (event.getBlock() == e.getCurrentItem() && (this.items.contains(event.getBlock().getType().toString()) || this.items.contains(String.valueOf(event.getBlock().getTypeId())))) {
                if (this.itemsSmelted.contains(event.getBlock().getTypeId())) {
                    return;
                }
                this.itemsSmelted.add(event.getBlock().getTypeId());
                ++this.currentItems;
                this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " smelted a " + event.getBlock().getType().toString() + ".");
                this.complete(false);
            }
        }
    }

    @EventHandler
    public void listenFish(PlayerFishEvent event) {
        if (this.type == ItemType.FISH && event.getPlayer() == this.thePlayer && this.items.contains(event.getCaught().getType().toString())) {
            if (this.itemsFished.contains(event.getCaught().getType())) {
                return;
            }
            this.itemsFished.add(event.getCaught().getType());
            ++this.currentItems;
            this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " fished a " + event.getCaught().getType().toString() + ".");
            this.complete(false);
        }
    }

    @Override
    public void save() {
        try {
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Listen Type", (Object)"ITEM");
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Script", (Object)this.scriptName);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Type", (Object)this.type.toString());
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Items", this.items);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Quantity", (Object)this.quantity);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Current Items", (Object)this.currentItems);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to save ITEM listener for '%s'!", this.thePlayer.getName());
        }
    }

    @Override
    public void load(Player thePlayer, String listenerId) {
        try {
            this.thePlayer = thePlayer;
            this.listenerId = listenerId;
            this.scriptName = this.plugin.getSaves().getString("Player." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Script");
            this.type = ItemType.valueOf(this.plugin.getSaves().getString("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Type"));
            this.items = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Items");
            this.quantity = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Quantity");
            this.currentItems = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Current Items");
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to load ITEM listener for '%s'!", thePlayer.getName());
            this.cancel();
        }
    }

    @Override
    public void complete(boolean forceable) {
        if (this.quantity >= this.currentItems || forceable) {
            CraftItemEvent.getHandlerList().unregister((Listener)this);
            FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            PlayerFishEvent.getHandlerList().unregister((Listener)this);
            this.plugin.getCommandRegistry().getCommand(ListenCommand.class).finish(this.thePlayer, this.listenerId, this.scriptName, this);
        }
    }

    @Override
    public void cancel() {
        CraftItemEvent.getHandlerList().unregister((Listener)this);
        FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        this.plugin.getCommandRegistry().getCommand(ListenCommand.class).cancel(this.thePlayer, this.listenerId);
    }

    @Override
    public void report() {
    }

    static enum ItemType {
        CRAFT,
        SMELT,
        FISH;

    }
}

