/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.commands.core.ListenCommand;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class KillListener
extends AbstractListener {
    KillType type;
    List<String> targets;
    List<String> targetIds;
    int quantity = 0;
    String listenerId;
    int currentKills = 0;

    @Override
    public void build(String listenerId, Player thePlayer, String[] args, String scriptName) {
        this.listenerId = listenerId;
        this.thePlayer = thePlayer;
        this.scriptName = scriptName;
        try {
            this.type = KillType.valueOf(args[0]);
            this.targets = new ArrayList<String>(Arrays.asList(args[1].toUpperCase().split(",")));
            this.targetIds = new ArrayList<String>(Arrays.asList(args[2].split(",")));
            this.quantity = Integer.valueOf(args[3]);
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to build KILL listener for '%s'!", thePlayer.getName());
            e.printStackTrace();
            this.cancel();
        }
    }

    @EventHandler
    public void listen(EntityDeathEvent event) {
        block2: {
            block5: {
                block4: {
                    block3: {
                        if (event.getEntity().getKiller() != this.thePlayer) break block2;
                        if (this.type != KillType.ENTITY) break block3;
                        if (!this.targets.contains(event.getEntityType().toString()) && !this.targets.contains("*")) break block2;
                        ++this.currentKills;
                        this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " killed a " + event.getEntityType().toString() + ".");
                        this.complete(false);
                        break block2;
                    }
                    if (this.type != KillType.NPC) break block4;
                    if (!CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity()) || !this.targets.contains(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getName().toUpperCase()) && !this.targets.contains("*") && !this.targetIds.contains(String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getId()))) break block2;
                    ++this.currentKills;
                    this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " killed " + String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getId()) + "/" + CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getName() + ".");
                    this.complete(false);
                    break block2;
                }
                if (this.type != KillType.PLAYER) break block5;
                if (event.getEntityType() != EntityType.PLAYER || !this.targets.contains(((Player)event.getEntity()).getName().toUpperCase()) && !this.targets.contains("*")) break block2;
                ++this.currentKills;
                this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " killed " + ((Player)event.getEntity()).getName().toUpperCase() + ".");
                this.complete(false);
                break block2;
            }
            if (this.type == KillType.GROUP && event.getEntityType() == EntityType.PLAYER) {
                for (String group : this.plugin.perms.getPlayerGroups((Player)event.getEntity())) {
                    if (!this.targets.contains(group.toUpperCase())) continue;
                    ++this.currentKills;
                    this.aH.echoDebug(ChatColor.YELLOW + "// " + this.thePlayer.getName() + " killed " + ((Player)event.getEntity()).getName().toUpperCase() + " of group " + group + ".");
                    this.complete(false);
                    break;
                }
            }
        }
    }

    @Override
    public void complete(boolean forceable) {
        if (this.currentKills >= this.quantity || forceable) {
            EntityDeathEvent.getHandlerList().unregister((Listener)this);
            this.plugin.getCommandRegistry().getCommand(ListenCommand.class).finish(this.thePlayer, this.listenerId, this.scriptName, this);
        }
    }

    @Override
    public void cancel() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
        this.plugin.getCommandRegistry().getCommand(ListenCommand.class).cancel(this.thePlayer, this.listenerId);
    }

    @Override
    public void save() {
        try {
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Listen Type", (Object)"KILL");
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Script", (Object)this.scriptName);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Type", (Object)this.type.toString());
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Targets", this.targets);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Quantity", (Object)this.quantity);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Current Kills", (Object)this.currentKills);
            this.plugin.getSaves().set("Players." + this.thePlayer.getName() + ".Listeners.Saves." + this.listenerId + ".Target NPCIds", this.targetIds);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to save KILL listener for '%s'!", this.thePlayer.getName());
        }
    }

    @Override
    public void load(Player thePlayer, String listenerId) {
        try {
            this.thePlayer = thePlayer;
            this.listenerId = listenerId;
            this.scriptName = this.plugin.getSaves().getString("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Script");
            this.type = KillType.valueOf(this.plugin.getSaves().getString("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Type"));
            this.targets = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Targets");
            this.quantity = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Quantity");
            this.currentKills = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Current Kills");
            this.targetIds = this.plugin.getSaves().getStringList("Players." + thePlayer.getName() + ".Listeners.Saves." + listenerId + ".Target NPCIds");
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        catch (Exception e) {
            this.aH.echoError("Unable to load KILL listener for '%s'!", thePlayer.getName());
            this.cancel();
        }
    }

    @Override
    public void report() {
        this.aH.echoDebug(this.thePlayer.getName() + " ID: " + this.listenerId + " SCRIPT: " + this.scriptName + " TYPE: " + this.type.name() + " TARGETS: " + this.targets.toString() + "/" + this.targetIds.toString() + " QTY: " + this.quantity + " CURRENT: " + this.currentKills);
    }

    static enum KillType {
        PLAYER,
        GROUP,
        ENTITY,
        NPC;

    }
}

