/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.commands.core.EngageCommand;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.LookClose;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DenizenNPC {
    private NPC citizensNPC;
    private Denizen plugin;
    private ScriptHelper sE;

    DenizenNPC(NPC citizensNPC) {
        this.citizensNPC = citizensNPC;
        this.plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        this.sE = this.plugin.getScriptEngine().helper;
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizensEntity() {
        return this.citizensNPC;
    }

    public LivingEntity getEntity() {
        try {
            return this.citizensNPC.getBukkitEntity();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void talk(SpeechEngine.TalkType talkType, Player thePlayer, String theText) {
        this.plugin.getSpeechEngine().talk(this, thePlayer, theText, talkType);
    }

    public void talk(SpeechEngine.TalkType talkType, Player thePlayer, SpeechEngine.Reason theReason) {
        this.plugin.getSpeechEngine().talk(this, thePlayer, theReason, talkType);
    }

    public boolean isToggled() {
        return ((DenizenTrait)this.citizensNPC.getTrait(DenizenTrait.class)).isToggled();
    }

    public EntityType getEntityType() {
        return this.citizensNPC.getBukkitEntity().getType();
    }

    public Navigator getNavigator() {
        return this.citizensNPC.getNavigator();
    }

    public int getId() {
        return this.citizensNPC.getId();
    }

    public String getName() {
        return this.citizensNPC.getName();
    }

    public void showInfo(Player theClicker) {
        this.plugin.getDenizenNPCRegistry().showInfo(theClicker, this);
    }

    public boolean isInteractable(String triggerName, Player thePlayer) {
        return this.sE.denizenIsInteractable(triggerName, this);
    }

    public String getInteractScript(Player thePlayer, Class<? extends AbstractTrigger> triggerType) {
        return this.sE.getInteractScript(this, thePlayer, triggerType);
    }

    public boolean isSpawned() {
        return this.citizensNPC.isSpawned();
    }

    public Location getLocation() {
        return this.citizensNPC.getBukkitEntity().getLocation();
    }

    public World getWorld() {
        return this.citizensNPC.getBukkitEntity().getWorld();
    }

    public void setHealth(int newHealth) {
        ((CraftLivingEntity)this.getEntity()).getHandle().setHealth(newHealth);
    }

    public String toString() {
        return "DenizenNPC " + this.citizensNPC.getName() + "/" + this.citizensNPC.getId();
    }

    public boolean isLookingClose() {
        ((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle();
        return ((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle();
    }

    public void lookClose(boolean lookclose) {
        if (!lookclose) {
            if (((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle()) {
                ((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle();
            }
        } else if (lookclose && !((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle()) {
            ((LookClose)this.citizensNPC.getTrait(LookClose.class)).toggle();
        }
    }

    public boolean isInteracting() {
        return !this.plugin.getCommandRegistry().getCommand(EngageCommand.class).getEngaged(this);
    }

    public boolean hasTrigger(String triggerName) {
        return ((DenizenTrait)this.citizensNPC.getTrait(DenizenTrait.class)).triggerIsEnabled(triggerName);
    }
}

