/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.bookmarks.BookmarkHelper;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DenizenNPCRegistry {
    private Map<NPC, DenizenNPC> denizenNPCs = new ConcurrentHashMap<NPC, DenizenNPC>();
    public Denizen plugin;

    public DenizenNPCRegistry(Denizen denizen) {
        this.plugin = denizen;
    }

    public void registerNPC(NPC citizensNPC) {
        if (!this.denizenNPCs.containsKey(citizensNPC)) {
            this.denizenNPCs.put(citizensNPC, new DenizenNPC(citizensNPC));
        }
    }

    public void removeNPC(NPCRemoveEvent event) {
        if (this.isDenizenNPC(event.getNPC())) {
            this.denizenNPCs.remove(event.getNPC());
        }
    }

    public DenizenNPC getDenizen(NPC citizensNPC) {
        if (citizensNPC.hasTrait(DenizenTrait.class) && this.denizenNPCs.containsKey(citizensNPC)) {
            return this.denizenNPCs.get(citizensNPC);
        }
        return null;
    }

    public boolean isDenizenNPC(NPC citizensNPC) {
        return this.denizenNPCs.containsKey(citizensNPC);
    }

    public Map<NPC, DenizenNPC> getDenizens() {
        for (Map.Entry<NPC, DenizenNPC> npc : this.denizenNPCs.entrySet()) {
            try {
                npc.getKey().getBukkitEntity();
            }
            catch (NullPointerException e) {
                this.denizenNPCs.remove(npc.getKey());
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.plugin.getLogger().log(Level.INFO, "Removed NPC from DenizenRegistry. The bukkit entity has been removed.");
            }
        }
        return this.denizenNPCs;
    }

    public DenizenNPC getClosest(Player thePlayer, int Range) {
        Double closestDistance = Double.valueOf(String.valueOf(Range));
        DenizenNPC closestDenizen = null;
        if (this.getDenizens().isEmpty()) {
            return null;
        }
        for (DenizenNPC aDenizen : this.getDenizens().values()) {
            if (!aDenizen.isSpawned() || !aDenizen.getWorld().equals(thePlayer.getWorld()) || !(aDenizen.getLocation().distance(thePlayer.getLocation()) < closestDistance)) continue;
            closestDenizen = aDenizen;
            closestDistance = aDenizen.getLocation().distance(thePlayer.getLocation());
        }
        return closestDenizen;
    }

    public List<DenizenNPC> getInRange(Player thePlayer, int theRange) {
        ArrayList<DenizenNPC> DenizensWithinRange = new ArrayList<DenizenNPC>();
        if (this.plugin.getDenizenNPCRegistry().getDenizens().isEmpty()) {
            return DenizensWithinRange;
        }
        for (DenizenNPC aDenizenList : this.plugin.getDenizenNPCRegistry().getDenizens().values()) {
            if (!aDenizenList.isSpawned() || !aDenizenList.getWorld().equals(thePlayer.getWorld()) || !(aDenizenList.getLocation().distance(thePlayer.getLocation()) < (double)theRange)) continue;
            DenizensWithinRange.add(aDenizenList);
        }
        return DenizensWithinRange;
    }

    public List<Player> getInRange(LivingEntity theEntity, int theRange) {
        Player[] DenizenPlayers;
        ArrayList<Player> PlayersWithinRange = new ArrayList<Player>();
        for (Player aPlayer : DenizenPlayers = this.plugin.getServer().getOnlinePlayers()) {
            if (!aPlayer.isOnline() || !aPlayer.getWorld().equals(theEntity.getWorld()) || !(aPlayer.getLocation().distance(theEntity.getLocation()) < (double)theRange)) continue;
            PlayersWithinRange.add(aPlayer);
        }
        return PlayersWithinRange;
    }

    public List<Player> getInRange(LivingEntity theEntity, int theRange, Player excludePlayer) {
        List<Player> PlayersWithinRange = this.getInRange(theEntity, theRange);
        if (excludePlayer != null) {
            PlayersWithinRange.remove(excludePlayer);
        }
        return PlayersWithinRange;
    }

    public boolean checkLocation(Player thePlayer, Location theLocation, int theLeeway) {
        if (!thePlayer.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        if (Math.abs(thePlayer.getLocation().getBlockX() - theLocation.getBlockX()) > theLeeway) {
            return false;
        }
        if (Math.abs(thePlayer.getLocation().getBlockY() - theLocation.getBlockY()) > theLeeway) {
            return false;
        }
        return Math.abs(thePlayer.getLocation().getBlockZ() - theLocation.getBlockZ()) <= theLeeway;
    }

    public boolean checkLocation(DenizenNPC theDenizen, Location theLocation, int theLeeway) {
        if (!theDenizen.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        if (Math.abs(theDenizen.getLocation().getBlockX() - theLocation.getBlockX()) > theLeeway) {
            return false;
        }
        if (Math.abs(theDenizen.getLocation().getBlockY() - theLocation.getBlockY()) > theLeeway) {
            return false;
        }
        return Math.abs(theDenizen.getLocation().getBlockZ() - theLocation.getBlockZ()) <= theLeeway;
    }

    public void showInfo(Player thePlayer, DenizenNPC theDenizen) {
        thePlayer.sendMessage(ChatColor.GOLD + "------ Denizen Info ------");
        thePlayer.sendMessage(ChatColor.GRAY + "C2 NPCID: " + ChatColor.GREEN + theDenizen.getId() + ChatColor.GRAY + "   Name: " + ChatColor.GREEN + theDenizen.getName() + ChatColor.GRAY + "   HPs: " + ChatColor.GREEN + theDenizen.getEntity().getHealth() + ChatColor.GRAY + "   GOAL CNTRLR: " + ChatColor.GREEN + String.valueOf(Boolean.valueOf(theDenizen.getCitizensEntity().getDefaultGoalController().isPaused()) == false));
        thePlayer.sendMessage(ChatColor.GRAY + "PF RANGE: " + ChatColor.GREEN + theDenizen.getNavigator().getDefaultParameters().range() + "   " + ChatColor.GRAY + "SPEED: " + ChatColor.GREEN + String.valueOf(theDenizen.getNavigator().getDefaultParameters().speed()) + "    " + ChatColor.GRAY + "AVOID WATER: " + ChatColor.GREEN + theDenizen.getNavigator().getDefaultParameters().avoidWater());
        thePlayer.sendMessage(ChatColor.GRAY + "NAVIGATING: " + ChatColor.GREEN + theDenizen.getNavigator().isNavigating() + "   " + ChatColor.GRAY + "STATIONARY TICKS: " + ChatColor.GREEN + theDenizen.getNavigator().getDefaultParameters().stationaryTicks() + "   " + ChatColor.GRAY + "PUSHABLE: " + ChatColor.GREEN + ((DenizenTrait)theDenizen.getCitizensEntity().getTrait(DenizenTrait.class)).isPushable());
        thePlayer.sendMessage("");
        thePlayer.sendMessage(ChatColor.GRAY + "Trigger Status:");
        for (String line : this.plugin.getSpeechEngine().getMultilineText(((DenizenTrait)theDenizen.getCitizensEntity().getTrait(DenizenTrait.class)).listTriggers())) {
            thePlayer.sendMessage(line);
        }
        thePlayer.sendMessage("");
        boolean scriptsPresent = false;
        thePlayer.sendMessage(ChatColor.GRAY + "Interact Scripts:");
        if (this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Interact Scripts")) {
            if (!this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Interact Scripts").isEmpty()) {
                scriptsPresent = true;
            }
            for (String scriptEntry : this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Interact Scripts")) {
                thePlayer.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + scriptEntry);
            }
        }
        if (this.plugin.getAssignments().contains("Denizens." + theDenizen.getId() + ".Interact Scripts")) {
            if (!this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getId() + ".Interact Scripts").isEmpty()) {
                scriptsPresent = true;
            }
            for (String scriptEntry : this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getId() + ".Interact Scripts")) {
                thePlayer.sendMessage(ChatColor.GRAY + "- " + ChatColor.YELLOW + scriptEntry);
            }
        }
        if (!scriptsPresent) {
            thePlayer.sendMessage(ChatColor.RED + "  No scripts assigned!");
        }
        thePlayer.sendMessage("");
        boolean activitiesPresent = false;
        thePlayer.sendMessage(ChatColor.GRAY + "Scheduled Activities:");
        if (this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Scheduled Activities")) {
            if (!this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Scheduled Activities").isEmpty()) {
                activitiesPresent = true;
            }
            for (String scriptEntry : this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Scheduled Activities")) {
                thePlayer.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + scriptEntry);
            }
        }
        if (!activitiesPresent) {
            thePlayer.sendMessage(ChatColor.RED + "  No activities scheduled!");
        }
        thePlayer.sendMessage("");
        DecimalFormat lf = new DecimalFormat("###.##");
        boolean bookmarksPresent = false;
        thePlayer.sendMessage(ChatColor.GRAY + "Bookmarks:");
        if (this.plugin.getSaves().contains("Denizens." + theDenizen.getName() + ".Bookmarks.Location")) {
            if (!this.plugin.getSaves().getStringList("Denizens." + theDenizen.getName() + ".Bookmarks.Location").isEmpty()) {
                bookmarksPresent = true;
            }
            for (String bookmarkEntry : this.plugin.getSaves().getStringList("Denizens." + theDenizen.getName() + ".Bookmarks.Location")) {
                if (bookmarkEntry.split(";").length < 6) continue;
                thePlayer.sendMessage(ChatColor.GRAY + "- Type: " + ChatColor.GREEN + "LOCATION " + ChatColor.GRAY + "Name: " + ChatColor.GREEN + bookmarkEntry.split(" ")[0] + ChatColor.GRAY + " in World: " + ChatColor.GREEN + bookmarkEntry.split(" ")[1].split(";")[0]);
                thePlayer.sendMessage(" " + ChatColor.GRAY + "  at X: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[1])) + ChatColor.GRAY + " Y: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[2])) + ChatColor.GRAY + " Z: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[3])) + ChatColor.GRAY + " Pitch: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[4])) + ChatColor.GRAY + " Yaw: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[5])));
            }
        }
        if (this.plugin.getSaves().contains("Denizens." + theDenizen.getId() + ".Bookmarks.Location")) {
            if (!this.plugin.getSaves().getStringList("Denizens." + theDenizen.getId() + ".Bookmarks.Location").isEmpty()) {
                bookmarksPresent = true;
            }
            for (String bookmarkEntry : this.plugin.getSaves().getStringList("Denizens." + theDenizen.getId() + ".Bookmarks.Location")) {
                if (bookmarkEntry.split(";").length < 6) continue;
                thePlayer.sendMessage(ChatColor.GRAY + "- Type: " + ChatColor.YELLOW + "LOCATION " + ChatColor.GRAY + "Name: " + ChatColor.YELLOW + bookmarkEntry.split(" ")[0] + ChatColor.GRAY + " in World: " + ChatColor.YELLOW + bookmarkEntry.split(" ")[1].split(";")[0]);
                thePlayer.sendMessage(" " + ChatColor.GRAY + "  at X: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[1])) + ChatColor.GRAY + " Y: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[2])) + ChatColor.GRAY + " Z: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[3])) + ChatColor.GRAY + " Pitch: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[4])) + ChatColor.GRAY + " Yaw: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[5])));
            }
        }
        if (this.plugin.getSaves().contains("Denizens." + theDenizen.getName() + ".Bookmarks.Block")) {
            if (!this.plugin.getSaves().getStringList("Denizens." + theDenizen.getName() + ".Bookmarks.Block").isEmpty()) {
                bookmarksPresent = true;
            }
            for (String bookmarkEntry : this.plugin.getSaves().getStringList("Denizens." + theDenizen.getName() + ".Bookmarks.Block")) {
                if (bookmarkEntry.split(";").length < 4) continue;
                thePlayer.sendMessage(ChatColor.GRAY + "- Type: " + ChatColor.GREEN + "BLOCK " + ChatColor.GRAY + "Name: " + ChatColor.GREEN + bookmarkEntry.split(" ")[0] + ChatColor.GRAY + " in World: " + ChatColor.GREEN + bookmarkEntry.split(" ")[1].split(";")[0]);
                thePlayer.sendMessage(" " + ChatColor.GRAY + "  at X: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[1])) + ChatColor.GRAY + " Y: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[2])) + ChatColor.GRAY + " Z: " + ChatColor.GREEN + lf.format(Double.valueOf(bookmarkEntry.split(";")[3])) + ChatColor.GRAY + " Material: " + ChatColor.GREEN + this.plugin.bookmarks.get(theDenizen, bookmarkEntry.split(" ")[0], BookmarkHelper.BookmarkType.BLOCK).getBlock().getType().toString());
            }
        }
        if (this.plugin.getSaves().contains("Denizens." + theDenizen.getId() + ".Bookmarks.Block")) {
            if (!this.plugin.getSaves().getStringList("Denizens." + theDenizen.getId() + ".Bookmarks.Block").isEmpty()) {
                bookmarksPresent = true;
            }
            for (String bookmarkEntry : this.plugin.getSaves().getStringList("Denizens." + theDenizen.getId() + ".Bookmarks.Block")) {
                if (bookmarkEntry.split(";").length < 4) continue;
                thePlayer.sendMessage(ChatColor.GRAY + "- Type: " + ChatColor.YELLOW + "BLOCK " + ChatColor.GRAY + "Name: " + ChatColor.YELLOW + bookmarkEntry.split(" ")[0] + ChatColor.GRAY + " in World: " + ChatColor.GREEN + bookmarkEntry.split(" ")[1].split(";")[0]);
                thePlayer.sendMessage(" " + ChatColor.GRAY + "  at X: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[1])) + ChatColor.GRAY + " Y: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[2])) + ChatColor.GRAY + " Z: " + ChatColor.YELLOW + lf.format(Double.valueOf(bookmarkEntry.split(";")[3])) + ChatColor.GRAY + " Material: " + ChatColor.YELLOW + this.plugin.bookmarks.get(theDenizen, bookmarkEntry.split(" ")[0], BookmarkHelper.BookmarkType.BLOCK).getBlock().getType().toString());
            }
        }
        if (!bookmarksPresent) {
            thePlayer.sendMessage(ChatColor.RED + "  No bookmarks defined!");
        }
        thePlayer.sendMessage("");
    }
}

