/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.runnables.TwoItemRunnable;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DenizenTrait
extends Trait
implements Toggleable,
Listener {
    private Map<String, Boolean> triggerMap = new HashMap<String, Boolean>();
    private Denizen plugin;
    private boolean isToggled = true;
    private boolean pushable = false;
    private boolean pushLocation = false;
    private Location pushedLocation;

    public DenizenTrait() {
        super("denizen");
    }

    @EventHandler
    public void NPCPush(NPCPushEvent event) {
        if (event.getNPC() == this.npc && this.pushable && this.isToggled) {
            event.setCancelled(false);
            if (!this.pushLocation) {
                this.pushLocation = true;
                this.pushedLocation = this.npc.getBukkitEntity().getLocation().clone();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TwoItemRunnable<NPC, Location>(this.npc, this.npc.getBukkitEntity().getLocation().clone()){

                    @Override
                    public void run(NPC theNPC, Location theLocation) {
                        DenizenTrait.this.navigateBack();
                    }
                }, 20L);
            }
        }
    }

    protected void navigateBack() {
        if (this.npc.getNavigator().isNavigating()) {
            this.pushLocation = false;
        }
        if (this.pushLocation) {
            this.pushLocation = false;
            this.npc.getNavigator().setTarget(this.pushedLocation);
            this.pushLocation = true;
        }
    }

    @EventHandler
    public void NPCCompleteDestination(NavigationCompleteEvent event) {
        if (this.pushLocation && event.getNPC() == this.npc) {
            EntityLiving handle = ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle();
            handle.yaw = this.pushedLocation.getYaw();
            handle.pitch = this.pushedLocation.getPitch();
            handle.az = handle.yaw;
            this.pushLocation = false;
        }
    }

    public void onSpawn() {
        this.plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        this.plugin.getDenizenNPCRegistry().registerNPC(this.npc);
        for (String theTriggerName : this.plugin.getTriggerRegistry().listTriggers().keySet()) {
            if (this.triggerMap.containsKey(theTriggerName)) continue;
            this.triggerMap.put(theTriggerName, this.plugin.getTriggerRegistry().getTrigger(theTriggerName).getEnabledByDefault());
        }
    }

    public void load(DataKey key) throws NPCLoadException {
        this.plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        this.plugin.getDenizenNPCRegistry().registerNPC(this.npc);
        this.isToggled = key.getBoolean("toggled", true);
        this.pushable = key.getBoolean("pushable", false);
        for (String theTriggerName : this.plugin.getTriggerRegistry().listTriggers().keySet()) {
            if (key.keyExists("enable." + theTriggerName.toLowerCase() + "-trigger")) {
                this.triggerMap.put(theTriggerName, key.getBoolean("enable." + theTriggerName.toLowerCase() + "-trigger"));
                continue;
            }
            this.triggerMap.put(theTriggerName, this.plugin.getTriggerRegistry().getTrigger(theTriggerName).getEnabledByDefault());
        }
    }

    public void save(DataKey key) {
        key.setBoolean("toggled", this.isToggled);
        key.setBoolean("pushable", this.pushable);
        for (Map.Entry<String, Boolean> theEntry : this.triggerMap.entrySet()) {
            key.setBoolean("enable." + theEntry.getKey().toLowerCase() + "-trigger", theEntry.getValue().booleanValue());
        }
    }

    public boolean toggle() {
        this.isToggled = !this.isToggled;
        return this.isToggled;
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public boolean triggerIsEnabled(String theName) {
        if (this.triggerMap.containsKey(theName.toUpperCase())) {
            return this.triggerMap.get(theName.toUpperCase());
        }
        return false;
    }

    public String listTriggers() {
        String theList = "";
        for (Map.Entry<String, Boolean> theEntry : this.triggerMap.entrySet()) {
            if (theEntry.getValue().booleanValue()) {
                theList = theList + ChatColor.GREEN + theEntry.getKey().toLowerCase() + "-trigger" + ChatColor.GRAY + ", ";
                continue;
            }
            theList = theList + ChatColor.RED + theEntry.getKey().toLowerCase() + "-trigger" + ChatColor.GRAY + ", ";
        }
        theList = theList.substring(0, theList.length() - 2);
        return theList;
    }

    public String toggleTrigger(String theTrigger) {
        if (this.triggerMap.containsKey(theTrigger.toUpperCase())) {
            if (this.triggerMap.get(theTrigger.toUpperCase()).booleanValue()) {
                this.triggerMap.put(theTrigger.toUpperCase(), false);
                return theTrigger + "-trigger now disabled.";
            }
            this.triggerMap.put(theTrigger.toUpperCase(), true);
            return theTrigger + "-trigger now enabled.";
        }
        return "Trigger not found!";
    }

    public boolean isPushable() {
        return this.pushable;
    }

    public boolean togglePushable() {
        this.pushable = !this.pushable;
        return this.pushable;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }
}

