/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.commands.ArgumentHelper;
import net.aufdemrand.denizen.npc.DenizenNPC;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class SpeechEngine {
    Denizen plugin;
    private ArgumentHelper aH = null;

    public SpeechEngine(Denizen plugin) {
        this.plugin = plugin;
    }

    public void talk(DenizenNPC theDenizen, Player thePlayer, String theText, TalkType talkType) {
        String[] formattedText = this.formatChatText(theText, talkType, thePlayer, theDenizen);
        List<String> playerText = this.getMultilineText(formattedText[0]);
        List<String> bystanderText = this.getMultilineText(formattedText[1]);
        if (!playerText.isEmpty()) {
            for (String text : playerText) {
                this.talkToPlayer(theDenizen, thePlayer, text, null, talkType);
            }
        }
        if (!bystanderText.isEmpty()) {
            for (String text : bystanderText) {
                if (!playerText.isEmpty()) {
                    this.talkToPlayer(theDenizen, thePlayer, "shhh...don't speak!", text, talkType);
                    continue;
                }
                this.talkToPlayer(theDenizen, thePlayer, null, text, talkType);
            }
        }
    }

    public void talk(DenizenNPC theDenizen, Player thePlayer, Reason theReason, TalkType talkType) {
        String textToSend = null;
        switch (theReason) {
            case DenizenIsUnavailable: {
                textToSend = this.plugin.getAssignments().getString("Denizens." + theDenizen.getName() + ".Texts.Denizen Unavailable");
                if (textToSend != null) {
                    if (textToSend.equals("")) {
                        return;
                    }
                    this.talk(theDenizen, thePlayer, textToSend, talkType);
                    break;
                }
                this.talk(theDenizen, thePlayer, this.plugin.settings.DefaultDenizenUnavailableText(), talkType);
                break;
            }
            case NoMatchingChatTriggers: {
                textToSend = this.plugin.getAssignments().getString("Denizens." + theDenizen.getName() + ".Texts.No Chat Trigger");
                if (textToSend != null) {
                    if (textToSend.equals("")) {
                        return;
                    }
                    this.talk(theDenizen, thePlayer, textToSend, talkType);
                    break;
                }
                this.talk(theDenizen, thePlayer, this.plugin.settings.DefaultNoChatTriggerText(), talkType);
                break;
            }
            case NoMatchingClickTrigger: {
                textToSend = this.plugin.getAssignments().getString("Denizens." + theDenizen.getName() + ".Texts.No Click Trigger");
                if (textToSend != null) {
                    if (textToSend.equals("")) {
                        return;
                    }
                    this.talk(theDenizen, thePlayer, textToSend, talkType);
                    break;
                }
                this.talk(theDenizen, thePlayer, this.plugin.settings.DefaultNoClickTriggerText(), talkType);
                break;
            }
            case NoMatchingDamageTrigger: {
                textToSend = this.plugin.getAssignments().getString("Denizens." + theDenizen.getName() + ".Texts.No Damage Trigger");
                if (textToSend != null) {
                    if (textToSend.equals("")) {
                        return;
                    }
                    this.talk(theDenizen, thePlayer, textToSend, talkType);
                    break;
                }
                this.talk(theDenizen, thePlayer, this.plugin.settings.DefaultNoDamageTriggerText(), talkType);
            }
        }
    }

    public String[] formatChatText(String theMessage, TalkType talkType, Player thePlayer, DenizenNPC theDenizen) {
        String playerMessageFormat = null;
        String bystanderMessageFormat = null;
        boolean toPlayer = true;
        if (thePlayer == null) {
            toPlayer = false;
        }
        String denizenName = "";
        String worldName = "";
        if (theDenizen != null) {
            denizenName = theDenizen.getName();
            if (theDenizen.isSpawned()) {
                worldName = theDenizen.getWorld().getName();
            }
        }
        switch (talkType) {
            case SHOUT: {
                playerMessageFormat = this.plugin.settings.NpcShoutToPlayer();
                bystanderMessageFormat = this.plugin.settings.NpcShoutToPlayerBystander();
                if (toPlayer) break;
                bystanderMessageFormat = this.plugin.settings.NpcShoutToBystanders();
                break;
            }
            case WHISPER: {
                playerMessageFormat = this.plugin.settings.NpcWhisperToPlayer();
                bystanderMessageFormat = this.plugin.settings.NpcWhisperToPlayerBystander();
                if (toPlayer) break;
                bystanderMessageFormat = this.plugin.settings.NpcWhisperToBystanders();
                break;
            }
            case EMOTE: {
                toPlayer = false;
                bystanderMessageFormat = "<NPC> <TEXT>";
                break;
            }
            case NARRATE: {
                playerMessageFormat = "<TEXT>";
                break;
            }
            case CHAT: {
                playerMessageFormat = this.plugin.settings.NpcChatToPlayer();
                bystanderMessageFormat = this.plugin.settings.NpcChatToPlayerBystander();
                if (toPlayer) break;
                bystanderMessageFormat = this.plugin.settings.NpcChatToBystanders();
                break;
            }
            case CHAT_PLAYERONLY: {
                playerMessageFormat = this.plugin.settings.NpcChatToPlayer();
            }
        }
        String playername = "";
        String playerdispname = "";
        String playerhealth = "";
        if (thePlayer != null) {
            playerhealth = String.valueOf(thePlayer.getHealth());
            playerdispname = thePlayer.getDisplayName();
            playername = thePlayer.getName();
        }
        if (this.aH == null) {
            this.aH = this.plugin.getCommandRegistry().getArgumentHelper();
        }
        if (playerMessageFormat != null) {
            playerMessageFormat = this.colorizeText(playerMessageFormat.replace("<TEXT>", theMessage).replace("<NPC>", denizenName).replace("<PLAYER>", playername).replace("<DISPLAYNAME>", playerdispname).replace("<WORLD>", worldName).replace("<HEALTH>", playerhealth));
        }
        if (bystanderMessageFormat != null) {
            bystanderMessageFormat = this.colorizeText(bystanderMessageFormat.replace("<TEXT>", theMessage).replace("<NPC>", denizenName).replace("<PLAYER>", playername).replace("<DISPLAYNAME>", playerdispname).replace("<WORLD>", worldName).replace("<HEALTH>", playerhealth));
        }
        String[] returnedText = new String[]{playerMessageFormat, bystanderMessageFormat};
        return returnedText;
    }

    public List<String> getMultilineText(String theText) {
        ArrayList<String> processedText = new ArrayList<String>();
        if (theText == null) {
            return processedText;
        }
        String[] text = theText.split(" ");
        if (theText.length() > this.plugin.settings.MultiLineTextMaximumLength()) {
            processedText.add(0, "");
            int word = 0;
            int line = 0;
            while (word < text.length) {
                if (((String)processedText.get(line)).length() + text[word].length() < this.plugin.settings.MultiLineTextMaximumLength()) {
                    processedText.set(line, (String)processedText.get(line) + text[word] + " ");
                    ++word;
                    continue;
                }
                processedText.add("" + ChatColor.getLastColors((String)((String)processedText.get(++line - 1))));
            }
        } else {
            processedText.add(0, theText);
        }
        return processedText;
    }

    public void talkToPlayer(DenizenNPC theDenizen, Player thePlayer, String thePlayerMessage, String theBystanderMessage, TalkType talkType) {
        int theRange = 0;
        switch (talkType) {
            case SHOUT: {
                theRange = this.plugin.settings.NpcToPlayerShoutRangeInBlocks();
                break;
            }
            case WHISPER: {
                theRange = this.plugin.settings.NpcToPlayerWhisperRangeInBlocks();
                break;
            }
            case EMOTE: {
                theRange = this.plugin.settings.NpcEmoteRangeInBlocks();
                thePlayer.sendMessage(theBystanderMessage);
                break;
            }
            default: {
                theRange = this.plugin.settings.NpcToPlayerChatRangeInBlocks();
            }
        }
        if (thePlayerMessage != null && !thePlayerMessage.equals("shhh...don't speak!") && thePlayer != null) {
            thePlayer.sendMessage(thePlayerMessage);
        }
        if ((this.plugin.settings.BystandersHearNpcToPlayerChat() || thePlayerMessage == null) && theBystanderMessage != null && theRange > 0) {
            for (Player otherPlayer : this.plugin.getDenizenNPCRegistry().getInRange(theDenizen.getEntity(), theRange, thePlayer)) {
                otherPlayer.sendMessage(theBystanderMessage);
            }
        }
    }

    public String colorizeText(String text) {
        Integer i = 0;
        String[] code = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "k", "l", "m", "n", "o", "r"};
        for (ChatColor color : ChatColor.values()) {
            if (i > 22) break;
            text = text.replaceAll("(?i)<" + color.name() + ">", "" + color);
            text = text.replaceAll("(?i)<&" + code[i] + ">", "" + color);
            text = text.replaceAll("(?i)%%" + code[i], "" + color);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return text;
    }

    public void talkToDenizen(DenizenNPC theDenizen, Player thePlayer, String theMessage) {
        int theRange;
        thePlayer.sendMessage(this.colorizeText(this.plugin.settings.PlayerChatToNpc().replace("<TEXT>", theMessage).replace("<NPC>", theDenizen.getName()).replace("<PLAYER>", thePlayer.getName()).replace("<DISPLAYNAME>", thePlayer.getDisplayName()).replace("<WORLD>", thePlayer.getWorld().getName()).replace("<HEALTH>", String.valueOf(thePlayer.getHealth()))));
        if (this.plugin.settings.BystandersHearNpcToPlayerChat() && (theRange = this.plugin.settings.NpcToPlayerChatRangeInBlocks()) > 0) {
            for (Player otherPlayer : this.plugin.getDenizenNPCRegistry().getInRange(theDenizen.getEntity(), theRange, thePlayer)) {
                otherPlayer.sendMessage(this.colorizeText(this.plugin.settings.PlayerChatToNpcBystander().replace("<TEXT>", theMessage).replace("<NPC>", theDenizen.getName()).replace("<PLAYER>", thePlayer.getName()).replace("<DISPLAYNAME>", thePlayer.getDisplayName()).replace("<WORLD>", thePlayer.getWorld().getName()).replace("<HEALTH>", String.valueOf(thePlayer.getHealth()))));
            }
        }
    }

    public static enum TalkType {
        CHAT,
        EMOTE,
        SHOUT,
        WHISPER,
        NARRATE,
        CHAT_PLAYERONLY;

    }

    public static enum Reason {
        DenizenIsUnavailable,
        NoMatchingChatTriggers,
        NoMatchingClickTrigger,
        NoMatchingDamageTrigger;

    }
}

