/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.requirements;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.commands.core.FailCommand;
import net.aufdemrand.denizen.commands.core.FinishCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.citizensnpcs.command.exception.RequirementMissingException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class GetRequirements {
    private Denizen plugin;
    private CommandSender cs;

    public GetRequirements(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean check(String theScript, DenizenNPC theDenizen, LivingEntity theEntity, boolean isPlayer) throws RequirementMissingException {
        String requirementMode = this.plugin.getScripts().getString(theScript + ".Requirements.Mode");
        List requirementList = this.plugin.getScripts().getStringList(theScript + ".Requirements.List");
        int numberMet = 0;
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (requirementList == null || requirementMode == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No requirements found! This script may be named incorrectly, or simply doesn't exist! Looking for '" + theScript + ".Requirements.List'");
            }
            return false;
        }
        if (requirementMode.equals("NONE") || requirementList.isEmpty()) {
            return true;
        }
        for (String requirementEntry : requirementList) {
            boolean negativeRequirement;
            if (requirementEntry.startsWith("-")) {
                negativeRequirement = true;
                requirementEntry = requirementEntry.substring(1);
            } else {
                negativeRequirement = false;
            }
            if (this.plugin.getRequirementRegistry().listRequirements().containsKey(requirementEntry.split(" ")[0].toUpperCase())) {
                String[] builtArgs = null;
                if (requirementEntry.split(" ").length > 1) {
                    builtArgs = this.plugin.getScriptEngine().helper.buildArgs(requirementEntry.split(" ", 2)[1]);
                }
                if (!negativeRequirement) {
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Checking Requirement '" + requirementEntry.split(" ")[0].toUpperCase() + "'");
                    }
                } else if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Checking NEGATIVE Requirement '" + requirementEntry.split(" ")[0].toUpperCase() + "'");
                }
                if (this.plugin.getRequirementRegistry().getRequirement(requirementEntry.split(" ")[0].toUpperCase()).check((Player)theEntity, theDenizen, theScript, builtArgs, negativeRequirement)) {
                    ++numberMet;
                    if (!this.plugin.debugMode.booleanValue()) continue;
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "" + ChatColor.WHITE + "Requirement met!");
                    continue;
                }
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "" + ChatColor.WHITE + "Requirement not met!");
                continue;
            }
            int temp = numberMet;
            String[] arguments = new String[25];
            String[] argumentPopulator = requirementEntry.split(" ");
            for (int count = 0; count < 25; ++count) {
                arguments[count] = argumentPopulator.length > count ? argumentPopulator[count] : null;
            }
            try {
                switch (Requirement.valueOf(arguments[0].toUpperCase())) {
                    case NONE: {
                        return true;
                    }
                    case TIME: {
                        if (!this.plugin.getWorld.checkTime(theEntity.getWorld(), arguments[1], arguments[2], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case STORMING: 
                    case STORMY: 
                    case PRECIPITATING: 
                    case PRECIPITATION: {
                        if (!this.plugin.getWorld.checkWeather(theEntity.getWorld(), "PRECIPITATION", negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case SUNNY: {
                        if (!this.plugin.getWorld.checkWeather(theEntity.getWorld(), "SUNNY", negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case HUNGER: {
                        if (!this.plugin.getPlayer.checkSaturation((Player)theEntity, arguments[1], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case LEVEL: {
                        if (!this.plugin.getPlayer.checkLevel((Player)theEntity, arguments[1], arguments[2], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case WORLD: {
                        LinkedList<String> theWorlds = new LinkedList<String>();
                        for (String arg : arguments) {
                            if (arg == null) continue;
                            theWorlds.add(arg.toUpperCase());
                        }
                        theWorlds.remove(0);
                        if (!this.plugin.getWorld.checkWorld(theEntity, theWorlds, negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case NAME: {
                        LinkedList<String> theNames = new LinkedList<String>();
                        for (String arg : arguments) {
                            if (arg == null) continue;
                            theNames.add(arg.toUpperCase());
                        }
                        theNames.remove(0);
                        if (!this.plugin.getPlayer.checkName((Player)theEntity, theNames, negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case MONEY: {
                        if (!this.plugin.getPlayer.checkFunds((Player)theEntity, arguments[1], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case ITEM: {
                        String[] itemArgs = this.splitItem(arguments[1]);
                        if (!this.plugin.getPlayer.checkInventory((Player)theEntity, itemArgs[0], itemArgs[1], arguments[2], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case HOLDING: {
                        String[] holdingArgs = this.splitItem(arguments[1]);
                        if (!this.plugin.getPlayer.checkHand((Player)theEntity, holdingArgs[0], holdingArgs[1], arguments[2], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case WEARING: {
                        if (!this.plugin.getPlayer.checkArmor((Player)theEntity, arguments[1], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case POTIONEFFECT: {
                        LinkedList<String> thePotions = new LinkedList<String>();
                        for (String arg : arguments) {
                            if (arg == null) continue;
                            thePotions.add(arg.toUpperCase());
                        }
                        thePotions.remove(0);
                        if (!this.plugin.getPlayer.checkEffects((Player)theEntity, thePotions, negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case FINISHED: 
                    case SCRIPT: {
                        if (!this.plugin.getCommandRegistry().getCommand(FinishCommand.class).getScriptCompletes((Player)theEntity, requirementEntry.split(" ", 2)[1], requirementEntry.split(" ", 3)[1], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case FAILED: {
                        if (!this.plugin.getCommandRegistry().getCommand(FailCommand.class).getScriptFail((Player)theEntity, requirementEntry.split(" ", 2)[1], negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case GROUP: {
                        ArrayList<String> theGroups = new ArrayList<String>();
                        for (String arg : arguments) {
                            if (arg == null) continue;
                            theGroups.add(arg);
                        }
                        theGroups.remove(0);
                        if (!this.plugin.getPlayer.checkGroups((Player)theEntity, theGroups, negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case PERMISSION: {
                        LinkedList<String> thePermissions = new LinkedList<String>();
                        for (String arg : arguments) {
                            if (arg == null) continue;
                            thePermissions.add(arg);
                        }
                        thePermissions.remove(0);
                        if (!this.plugin.getPlayer.checkPermissions((Player)theEntity, thePermissions, negativeRequirement)) break;
                        ++numberMet;
                        break;
                    }
                    case DURABILITY: {
                        if (!this.plugin.getPlayer.checkDurability((Player)theEntity, arguments[1], arguments[2], negativeRequirement)) break;
                        ++numberMet;
                    }
                }
            }
            catch (Throwable e) {
                if (this.plugin.showStackTraces) {
                    this.plugin.getLogger().info(e.getMessage());
                }
                if (this.plugin.showStackTraces) {
                    e.printStackTrace();
                }
                throw new RequirementMissingException(e.getMessage());
            }
            String debugger = "";
            if (!negativeRequirement) {
                if (this.plugin.debugMode.booleanValue()) {
                    debugger = debugger + "Checking LEGACY Requirement '" + requirementEntry.split(" ")[0].toUpperCase() + "'... ";
                }
            } else if (this.plugin.debugMode.booleanValue()) {
                debugger = debugger + "Checking LEGACY NEGATIVE Requirement '" + requirementEntry.split(" ")[0].toUpperCase() + "'... ";
            }
            if (numberMet == temp) {
                if (this.plugin.debugMode.booleanValue()) {
                    debugger = debugger + "requirement not met!";
                }
            } else if (this.plugin.debugMode.booleanValue()) {
                debugger = debugger + "requirement met!";
            }
            if (!this.plugin.debugMode.booleanValue()) continue;
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + debugger);
        }
        if (requirementMode.equalsIgnoreCase("ALL") && numberMet == requirementList.size()) {
            return true;
        }
        String[] ModeArgs = requirementMode.split(" ");
        return ModeArgs[0].equalsIgnoreCase("ANY") && (ModeArgs.length == 1 ? numberMet >= 1 : numberMet >= Integer.parseInt(ModeArgs[1]));
    }

    public String[] splitItem(String theItemWithData) {
        String[] itemArgs = new String[2];
        if (theItemWithData.split(":", 2).length == 1) {
            itemArgs[0] = theItemWithData;
            itemArgs[1] = null;
        } else {
            itemArgs[0] = theItemWithData.split(":", 2)[0];
            itemArgs[1] = theItemWithData.split(":", 2)[1];
        }
        return itemArgs;
    }

    public static enum Requirement {
        NONE,
        NAME,
        WEARING,
        ITEM,
        HOLDING,
        TIME,
        PRECIPITATION,
        ACTIVITY,
        FINISHED,
        SCRIPT,
        FAILED,
        STORMY,
        SUNNY,
        HUNGER,
        WORLD,
        PERMISSION,
        LEVEL,
        GROUP,
        MONEY,
        POTIONEFFECT,
        PRECIPITATING,
        STORMING,
        DURABILITY;

    }

    public static enum RequirementMode {
        NONE,
        ALL,
        ANY;

    }
}

