/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.requirements;

import java.rmi.activation.ActivationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.requirements.AbstractRequirement;
import net.aufdemrand.denizen.requirements.core.EnchantedRequirement;
import net.aufdemrand.denizen.requirements.core.FlaggedRequirement;
import net.aufdemrand.denizen.requirements.core.HeroesRequirement;
import net.aufdemrand.denizen.requirements.core.LiquidRequirement;
import net.aufdemrand.denizen.requirements.core.OwnerRequirement;
import net.aufdemrand.denizen.requirements.core.PoweredRequirement;
import net.aufdemrand.denizen.requirements.core.ScriptRequirement;
import net.aufdemrand.denizen.requirements.core.SneakingRequirement;

public class RequirementRegistry {
    private Map<String, AbstractRequirement> requirements = new HashMap<String, AbstractRequirement>();
    private Map<Class<? extends AbstractRequirement>, String> requirementsClass = new HashMap<Class<? extends AbstractRequirement>, String>();
    public Denizen plugin;

    public RequirementRegistry(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean registerRequirement(String requirementName, AbstractRequirement requirementClass) {
        this.requirements.put(requirementName.toUpperCase(), requirementClass);
        this.requirementsClass.put(requirementClass.getClass(), requirementName.toUpperCase());
        this.plugin.getLogger().log(Level.INFO, "Loaded " + requirementName + " Requirement successfully!");
        return true;
    }

    public Map<String, AbstractRequirement> listRequirements() {
        return this.requirements;
    }

    public <T extends AbstractRequirement> T getRequirement(Class<T> theClass) {
        if (this.requirementsClass.containsKey(theClass)) {
            return (T)((AbstractRequirement)theClass.cast(this.requirements.get(this.requirementsClass.get(theClass))));
        }
        return null;
    }

    public AbstractRequirement getRequirement(String requirementName) {
        if (this.requirements.containsKey(requirementName.toUpperCase())) {
            return this.requirements.get(requirementName);
        }
        return null;
    }

    public void registerCoreRequirements() {
        FlaggedRequirement flaggedRequirement = new FlaggedRequirement();
        PoweredRequirement poweredRequirement = new PoweredRequirement();
        LiquidRequirement liquidRequirement = new LiquidRequirement();
        HeroesRequirement heroesRequirement = new HeroesRequirement();
        OwnerRequirement ownerRequirement = new OwnerRequirement();
        SneakingRequirement sneakingRequirement = new SneakingRequirement();
        EnchantedRequirement enchantedRequirement = new EnchantedRequirement();
        ScriptRequirement scriptRequirement = new ScriptRequirement();
        this.plugin.getLogger().info("Loading LEGACY requirements...DONE!");
        try {
            sneakingRequirement.activateAs("SNEAKING");
            enchantedRequirement.activateAs("ENCHANTED");
            heroesRequirement.activateAs("HEROESCLASS");
            ownerRequirement.activateAs("OWNER");
            flaggedRequirement.activateAs("FLAGGED");
            poweredRequirement.activateAs("ISPOWERED");
            scriptRequirement.activateAs("SCRIPT");
            liquidRequirement.activateAs("ISLIQUID");
        }
        catch (ActivationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Oh no! Denizen has run into a problem registering the core requirements!");
            e.printStackTrace();
        }
    }
}

