/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.requirements.core;

import com.herocraftonline.heroes.characters.Hero;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.requirements.AbstractRequirement;
import net.citizensnpcs.command.exception.RequirementMissingException;
import org.bukkit.entity.Player;

public class HeroesRequirement
extends AbstractRequirement {
    @Override
    public boolean check(Player thePlayer, DenizenNPC theDenizen, String theScript, String[] arguments, Boolean negativeRequirement) throws RequirementMissingException {
        boolean outcome = false;
        ClassType classType = ClassType.ANY;
        String classToCheck = null;
        if (arguments == null) {
            throw new RequirementMissingException("USAGE: HEROES_CLASS [CLASS_TYPE] (PRIMARY|SECONDARY)");
        }
        for (String thisArg : arguments) {
            if (thisArg.contains("PRIMARY")) {
                classType = ClassType.PRIMARY;
                this.aH.echoDebug("...checking only PRIMARY class.");
                continue;
            }
            if (thisArg.contains("SECOND")) {
                classType = ClassType.SECONDARY;
                this.aH.echoDebug("...checking only SECONDARY class.");
                continue;
            }
            classToCheck = thisArg.toUpperCase();
            this.aH.echoDebug("...checking for '%s' class.", thisArg);
        }
        if (this.plugin.heroes != null) {
            Hero theHero = this.plugin.heroes.getCharacterManager().getHero(thePlayer);
            if (classToCheck == null) {
                this.aH.echoError("...must provide a CLASS to check!");
                return false;
            }
            switch (classType) {
                case ANY: {
                    if (theHero.getSecondClass().getName().toUpperCase().equals(classToCheck) || theHero.getHeroClass().getName().toUpperCase().equals(classToCheck)) {
                        outcome = true;
                        this.aH.echoDebug("...class matched!");
                        break;
                    }
                    this.aH.echoDebug("...was looking for '" + classToCheck + "', but found '" + theHero.getHeroClass().getName().toUpperCase() + "' and '" + theHero.getSecondClass().getName().toUpperCase() + "'.");
                    break;
                }
                case PRIMARY: {
                    if (theHero.getHeroClass().getName().toUpperCase().equals(classToCheck)) {
                        outcome = true;
                        this.aH.echoDebug("...PRIMARY class matched!");
                        break;
                    }
                    this.aH.echoDebug("...was looking for '" + classToCheck + "', but found '" + theHero.getHeroClass().getName().toUpperCase() + "'.");
                    break;
                }
                case SECONDARY: {
                    if (theHero.getSecondClass().getName().toUpperCase().equals(classToCheck)) {
                        outcome = true;
                        this.aH.echoDebug("...SECONDARY class matched!");
                        break;
                    }
                    this.aH.echoDebug("...was looking for '" + classToCheck + "', but found '" + theHero.getSecondClass().getName().toUpperCase() + "'.");
                }
            }
        } else {
            throw new RequirementMissingException("Could not find Heroes!");
        }
        return negativeRequirement != outcome;
    }

    static enum ClassType {
        PRIMARY,
        SECONDARY,
        ANY;

    }
}

