/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.events.ScriptQueueEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ScriptEngine {
    private Denizen plugin;
    public ScriptHelper helper;
    private Map<Player, List<ScriptEntry>> triggerQue = new ConcurrentHashMap<Player, List<ScriptEntry>>();
    private Map<Player, List<ScriptEntry>> taskQue = new ConcurrentHashMap<Player, List<ScriptEntry>>();
    private Map<DenizenNPC, List<ScriptEntry>> activityQue = new ConcurrentHashMap<DenizenNPC, List<ScriptEntry>>();

    public ScriptEngine(Denizen denizen) {
        this.plugin = denizen;
        this.helper = new ScriptHelper(this.plugin);
    }

    public void runQueues() {
        ScriptEntry theCommand;
        boolean instantly;
        if (!this.triggerQue.isEmpty()) {
            for (Map.Entry<Player, List<ScriptEntry>> entry : this.triggerQue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getDelayedTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    theCommand = entry.getValue().get(0);
                    theCommand.setSendingQueue(QueueType.TRIGGER);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    ScriptQueueEvent event = new ScriptQueueEvent(theCommand.getPlayer(), theCommand);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isAltered()) {
                        theCommand = event.getScriptEntry();
                    }
                    entry.getValue().remove(0);
                    this.triggerQue.put(entry.getKey(), entry.getValue());
                    try {
                        if (event.isCancelled()) {
                            this.plugin.getLogger().info("Note: ScriptEntry cancelled!");
                            continue;
                        }
                        this.plugin.executer.execute(theCommand);
                    }
                    catch (Throwable e) {
                        this.plugin.getLogger().info("Woah! Bad command! Check syntax...");
                        if (!this.plugin.showStackTraces) continue;
                        e.printStackTrace();
                    }
                } while (instantly);
            }
        }
        if (!this.taskQue.isEmpty()) {
            for (Map.Entry<Player, List<ScriptEntry>> entry : this.taskQue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getDelayedTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    theCommand = entry.getValue().get(0);
                    theCommand.setSendingQueue(QueueType.TASK);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    entry.getValue().remove(0);
                    this.taskQue.put(entry.getKey(), entry.getValue());
                    this.plugin.executer.execute(theCommand);
                } while (instantly);
            }
        }
        if (!this.activityQue.isEmpty()) {
            for (Map.Entry<Object, List<ScriptEntry>> entry : this.activityQue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getDelayedTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    theCommand = entry.getValue().get(0);
                    theCommand.setSendingQueue(QueueType.ACTIVITY);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    entry.getValue().remove(0);
                    this.activityQue.put((DenizenNPC)entry.getKey(), entry.getValue());
                    this.plugin.executer.execute(theCommand);
                } while (instantly);
            }
        }
    }

    @Deprecated
    public boolean parseTaskScript(Player thePlayer, String theScript) {
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        List chatScriptItems = this.plugin.getScripts().getStringList(theScript + ".Script");
        for (String thisItem : chatScriptItems) {
            String[] scriptEntry = new String[2];
            scriptEntry = thisItem.split(" ", 2);
            try {
                scriptCommands.add(new ScriptEntry(scriptEntry[0], this.helper.buildArgs(scriptEntry[1]), thePlayer, theScript));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<ScriptEntry> scriptCommandList = this.taskQue.get(thePlayer);
        this.taskQue.remove(thePlayer);
        scriptCommandList.addAll(scriptCommands);
        this.taskQue.put(thePlayer, scriptCommandList);
        return true;
    }

    public void injectToQueue(Player thePlayer, List<ScriptEntry> scriptCommands, QueueType queueType, int thePosition) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case TRIGGER: {
                scriptCommandList = this.triggerQue.get(thePlayer);
                this.triggerQue.remove(thePlayer);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.addAll(thePosition, scriptCommands);
                this.triggerQue.put(thePlayer, scriptCommandList);
                break;
            }
            case TASK: {
                scriptCommandList = this.taskQue.get(thePlayer);
                this.taskQue.remove(thePlayer);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.addAll(thePosition, scriptCommands);
                this.taskQue.put(thePlayer, scriptCommandList);
            }
        }
    }

    public void injectToQueue(Player thePlayer, ScriptEntry scriptCommand, QueueType queueType, int thePosition) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case TRIGGER: {
                scriptCommandList = this.triggerQue.get(thePlayer);
                this.triggerQue.remove(thePlayer);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.add(thePosition, scriptCommand);
                this.triggerQue.put(thePlayer, scriptCommandList);
                break;
            }
            case TASK: {
                scriptCommandList = this.taskQue.get(thePlayer);
                this.taskQue.remove(thePlayer);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.add(thePosition, scriptCommand);
                this.taskQue.put(thePlayer, scriptCommandList);
            }
        }
    }

    public void injectToQueue(DenizenNPC theDenizen, List<ScriptEntry> scriptCommands, QueueType queueType, int thePosition) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case ACTIVITY: {
                scriptCommandList = this.activityQue.get(theDenizen);
                this.triggerQue.remove(theDenizen);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.addAll(thePosition, scriptCommands);
                this.activityQue.put(theDenizen, scriptCommandList);
            }
        }
    }

    public void injectToQue(DenizenNPC theDenizen, ScriptEntry scriptCommand, QueueType queueType, int thePosition) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case ACTIVITY: {
                scriptCommandList = this.activityQue.get(theDenizen);
                this.activityQue.remove(theDenizen);
                if (thePosition > scriptCommandList.size() || thePosition < 0) {
                    thePosition = 1;
                }
                if (scriptCommandList.size() == 0) {
                    thePosition = 0;
                }
                scriptCommandList.add(thePosition, scriptCommand);
                this.activityQue.put(theDenizen, scriptCommandList);
            }
        }
    }

    public Map<Player, List<ScriptEntry>> getQueue(QueueType queueType) {
        switch (queueType) {
            case TRIGGER: {
                return this.triggerQue;
            }
            case TASK: {
                return this.taskQue;
            }
        }
        return null;
    }

    public Map<DenizenNPC, List<ScriptEntry>> getDQueue(QueueType queueType) {
        return this.activityQue;
    }

    public void addToQue(Player thePlayer, List<ScriptEntry> scriptCommands, QueueType queueType) {
        switch (queueType) {
            case TRIGGER: {
                List<ScriptEntry> scriptCommandList = this.triggerQue.get(thePlayer);
                this.triggerQue.remove(thePlayer);
                scriptCommandList.addAll(scriptCommands);
                this.triggerQue.put(thePlayer, scriptCommandList);
                break;
            }
            case TASK: {
                List<ScriptEntry> scriptCommandList = this.taskQue.get(thePlayer);
                this.taskQue.remove(thePlayer);
                scriptCommandList.addAll(scriptCommands);
                this.taskQue.put(thePlayer, scriptCommandList);
            }
        }
    }

    public void addToQue(DenizenNPC theDenizen, List<ScriptEntry> scriptCommands, QueueType queueType) {
        switch (queueType) {
            case ACTIVITY: {
                List<ScriptEntry> scriptCommandList = this.activityQue.get(theDenizen);
                this.activityQue.remove(theDenizen);
                scriptCommandList.addAll(scriptCommands);
                this.activityQue.put(theDenizen, scriptCommandList);
            }
        }
    }

    public List<ScriptEntry> getPlayerQueue(Player thePlayer, QueueType sendingQueue) {
        return this.getQueue(sendingQueue).get(thePlayer) != null ? this.getQueue(sendingQueue).get(thePlayer) : new ArrayList<ScriptEntry>();
    }

    public List<ScriptEntry> getDenizenQueue(DenizenNPC theDenizen, QueueType sendingQueue) {
        return this.getDQueue(sendingQueue).get(theDenizen) != null ? this.getDQueue(sendingQueue).get(theDenizen) : new ArrayList<ScriptEntry>();
    }

    public void replacePlayerQue(Player thePlayer, List<ScriptEntry> scriptCommands, QueueType queueType) {
        switch (queueType) {
            case TRIGGER: {
                this.triggerQue.remove(thePlayer);
                this.triggerQue.put(thePlayer, scriptCommands);
                break;
            }
            case TASK: {
                this.taskQue.remove(thePlayer);
                this.taskQue.put(thePlayer, scriptCommands);
            }
        }
    }

    public void replaceDenizenQue(DenizenNPC theDenizen, List<ScriptEntry> scriptCommands) {
        this.activityQue.remove(theDenizen);
        this.activityQue.put(theDenizen, scriptCommands);
    }

    public static enum QueueType {
        TRIGGER,
        TASK,
        ACTIVITY,
        CUSTOM;

    }
}

