/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.commands.core.EngageCommand;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.scripts.PriorityPair;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.citizensnpcs.command.exception.RequirementMissingException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ScriptHelper {
    Denizen plugin;
    CommandSender cs;
    Map<DenizenNPC, Map<Class<?>, Long>> triggerCooldowns = new ConcurrentHashMap();
    public String scriptString = ".Script";

    ScriptHelper(Denizen plugin) {
        this.plugin = plugin;
    }

    public boolean checkCooldown(DenizenNPC theDenizen, Class<?> theTrigger) {
        if (!this.triggerCooldowns.containsKey(theDenizen)) {
            return true;
        }
        if (!this.triggerCooldowns.get(theDenizen).containsKey(theTrigger)) {
            return true;
        }
        return System.currentTimeMillis() >= this.triggerCooldowns.get(theDenizen).get(theTrigger);
    }

    public void setCooldown(DenizenNPC theDenizen, Class<?> triggerType, Long millis) {
        HashMap triggerMap = new HashMap();
        triggerMap.put(triggerType, System.currentTimeMillis() + millis);
        this.triggerCooldowns.put(theDenizen, triggerMap);
    }

    public boolean checkCooldown(Player thePlayer, String theScript) {
        if (this.plugin.getSaves().contains("Global.Scripts." + theScript + ".Cooldown Time")) {
            if (System.currentTimeMillis() < this.plugin.getSaves().getLong("Global.Scripts." + theScript + ".Cooldown Time")) {
                return false;
            }
            this.plugin.getSaves().set("Global.Scripts." + theScript + ".Cooldown Time", null);
        }
        if (!this.plugin.getSaves().contains("Players." + thePlayer.getName() + ".Scripts." + theScript + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= this.plugin.getSaves().getLong("Players." + thePlayer.getName() + ".Scripts." + theScript + ".Cooldown Time")) {
            this.plugin.getSaves().set("Players." + thePlayer.getName() + ".Scripts." + theScript + ".Cooldown Time", null);
            return true;
        }
        return false;
    }

    public void setooldown(Player thePlayer, String theScript, Long millis) {
        this.plugin.getSaves().set("Players." + thePlayer.getName() + "." + theScript + ".Cooldown Time", (Object)(System.currentTimeMillis() + millis));
    }

    public String getInteractScript(DenizenNPC theDenizen, Player thePlayer, Class<? extends AbstractTrigger> theTrigger) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Getting interact script: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        String theScript = null;
        List assignedScripts = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Interact Scripts");
        if (assignedScripts.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "Could not find any scripts assigned!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return null;
        }
        ArrayList<PriorityPair> interactableScripts = new ArrayList<PriorityPair>();
        Player theEntity = null;
        Boolean isPlayer = false;
        if (thePlayer != null) {
            theEntity = thePlayer;
            isPlayer = true;
        } else {
            theEntity = theDenizen.getEntity();
        }
        for (String scriptAssignment : assignedScripts) {
            String script = null;
            script = Character.isDigit(scriptAssignment.charAt(0)) ? scriptAssignment.split(" ", 2)[1].replace("^", "") : scriptAssignment;
            Integer priority = null;
            try {
                priority = Integer.valueOf(scriptAssignment.split(" ", 2)[0]);
            }
            catch (NumberFormatException e) {
                priority = 0;
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|" + ChatColor.RED + " ERROR! " + ChatColor.WHITE + "Script '" + script + "' has an invalid priority! Assuming '0'.");
                }
                scriptAssignment = "0 " + scriptAssignment;
            }
            try {
                if (this.plugin.getRequirements.check(script, theDenizen, (LivingEntity)theEntity, isPlayer)) {
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|" + ChatColor.GREEN + " OKAY!" + ChatColor.WHITE + " '" + scriptAssignment + "' meets requirements.");
                    }
                    if (thePlayer == null) continue;
                    if (this.checkCooldown(thePlayer, script)) {
                        interactableScripts.add(new PriorityPair(priority, scriptAssignment.split(" ", 2)[1]));
                        if (!this.plugin.debugMode.booleanValue()) continue;
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|");
                        continue;
                    }
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|" + ChatColor.WHITE + " ...but, isn't cooled down, yet! Skipping.");
                    }
                    if (!this.plugin.debugMode.booleanValue()) continue;
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|");
                    continue;
                }
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "'" + scriptAssignment + "' does not meet requirements.");
                }
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|");
            }
            catch (RequirementMissingException e) {
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "'" + scriptAssignment + "' has a bad requirement, skipping.");
                }
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "|");
            }
        }
        if (interactableScripts.size() == 1) {
            theScript = ((PriorityPair)interactableScripts.get((int)0)).name;
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + "Highest scoring script is " + theScript + ".");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return theScript.replace("^", "");
        }
        if (interactableScripts.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "Could not find any scripts assigned!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return null;
        }
        Collections.sort(interactableScripts);
        for (int a = interactableScripts.size() - 1; a >= 0; --a) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Checking script '" + ((PriorityPair)interactableScripts.get((int)a)).name + "'.");
            }
            if (((PriorityPair)interactableScripts.get((int)a)).name.startsWith("^")) {
                String theScriptName = ((PriorityPair)interactableScripts.get((int)a)).name.substring(1);
                String triggerString = String.valueOf(this.plugin.getTriggerRegistry().getTrigger(theTrigger).triggerName.charAt(0)).toUpperCase() + this.plugin.getTriggerRegistry().getTrigger(theTrigger).triggerName.substring(1).toLowerCase() + " Trigger";
                if (this.plugin.getScripts().contains(theScriptName + ".Steps." + this.getCurrentStep(thePlayer, theScriptName) + "." + triggerString)) {
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "...found trigger!");
                    }
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + " Highest scoring script is " + theScriptName + ".");
                    }
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
                    }
                    return theScriptName.replace("^", "");
                }
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "...no trigger on this overlay assignment. Skipping.");
                continue;
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "...script is good!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + " Highest scoring script is " + ((PriorityPair)interactableScripts.get((int)a)).name + ".");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return ((PriorityPair)interactableScripts.get((int)a)).name.replace("^", "");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No scripts meet requirements! E:1983");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
        }
        return null;
    }

    public int getCurrentStep(Player thePlayer, String theScript) {
        int currentStep = 1;
        if (this.plugin.getSaves().getString("Players." + thePlayer.getName() + "." + theScript + "." + "Current Step") != null) {
            currentStep = this.plugin.getSaves().getInt("Players." + thePlayer.getName() + "." + theScript + "." + "Current Step");
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "...current step is: " + currentStep);
            }
            return currentStep;
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "...current step not found, assuming '1'.");
        }
        return currentStep;
    }

    @Deprecated
    public String[] buildArgs(String stringArgs) {
        return this.buildArgs(null, null, stringArgs);
    }

    public String[] buildArgs(Player thePlayer, DenizenNPC theDenizen, String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        ArrayList<String> flaggedList = new ArrayList<String>();
        for (String arg : matchList) {
            if (arg.contains("<^")) {
                arg = this.plugin.getCommandRegistry().getArgumentHelper().fillReplaceables(thePlayer, theDenizen, arg, true);
            }
            flaggedList.add(arg);
        }
        String[] split = new String[flaggedList.size()];
        flaggedList.toArray(split);
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GRAY + "Args: " + Arrays.toString(flaggedList.toArray()));
        }
        return split;
    }

    public String getTriggerPath(String theScript, int theStep, String triggerName) {
        return theScript + ".Steps." + theStep + "." + triggerName + " Trigger.";
    }

    public List<String> getScript(String triggerPath) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        List<String> scriptList = new ArrayList<String>();
        if (this.plugin.getScripts().contains(triggerPath.replace("..", "."))) {
            scriptList = this.plugin.getScripts().getStringList(triggerPath.replace("..", "."));
        }
        if (scriptList.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR!" + ChatColor.WHITE + " Could not find script at:");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + triggerPath.replace("..", "."));
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Check YML spacing, or is something spelled wrong in your script?");
            }
        }
        return scriptList;
    }

    public boolean denizenIsInteractable(String triggerName, DenizenNPC theDenizen) {
        if (((DenizenTrait)theDenizen.getCitizensEntity().getTrait(DenizenTrait.class)).isToggled() && this.plugin.getScriptEngine().helper.checkCooldown(theDenizen, this.plugin.getTriggerRegistry().getTrigger(triggerName).getClass()) && !this.plugin.getCommandRegistry().getCommand(EngageCommand.class).getEngaged(theDenizen)) {
            return true;
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.plugin.getLogger().log(Level.INFO, theDenizen.getName() + " is not interactable.");
            if (!this.plugin.getScriptEngine().helper.checkCooldown(theDenizen, this.plugin.getTriggerRegistry().getTrigger(triggerName).getClass())) {
                this.plugin.getLogger().log(Level.INFO, "...the Player has not yet met cool-down.");
            }
            if (this.plugin.getCommandRegistry().getCommand(EngageCommand.class).getEngaged(theDenizen)) {
                this.plugin.getLogger().log(Level.INFO, "...the Denizen is ENGAGED.");
            }
        }
        return false;
    }

    public List<ScriptEntry> buildScriptEntries(Player thePlayer, List<String> theScript, String theScriptName) {
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| ");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Building the script:");
        }
        if (theScript == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        if (theScript.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        for (String thisItem : theScript) {
            String[] scriptEntry = new String[2];
            if (thisItem.split(" ", 2).length == 1) {
                scriptEntry[0] = thisItem;
                scriptEntry[1] = null;
            } else {
                scriptEntry = thisItem.split(" ", 2);
            }
            try {
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Adding '" + scriptEntry[0] + "' command.");
                }
                scriptCommands.add(new ScriptEntry(scriptEntry[0], this.buildArgs(thePlayer, null, scriptEntry[1]), thePlayer, theScriptName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }

    public List<ScriptEntry> buildScriptEntries(Player thePlayer, DenizenNPC theDenizen, List<String> theScript, String theScriptName, Integer theStep) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Building the script:");
        }
        if (theScript == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        if (theScript.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        for (String thisItem : theScript) {
            if (thisItem.toUpperCase().contains("ENGAGE") && thisItem.toUpperCase().contains("NOW")) {
                this.plugin.getCommandRegistry().getCommand(EngageCommand.class).setEngaged(theDenizen, true);
            }
            String[] scriptEntry = new String[2];
            if (thisItem.split(" ", 2).length == 1) {
                scriptEntry[0] = thisItem;
                scriptEntry[1] = null;
            } else {
                scriptEntry = thisItem.split(" ", 2);
            }
            try {
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Adding '" + scriptEntry[0] + "' command.");
                }
                scriptCommands.add(new ScriptEntry(scriptEntry[0], this.buildArgs(thePlayer, theDenizen, scriptEntry[1]), thePlayer, theDenizen, theScriptName, theStep));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }

    public List<ScriptEntry> buildScriptEntries(Player thePlayer, DenizenNPC theDenizen, List<String> theScript, String theScriptName, Integer theStep, String playerMessage, String theText) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Building the script:");
        }
        if (theScript == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        if (theScript.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        for (String thisItem : theScript) {
            if (thisItem.toUpperCase().contains("ENGAGE") && thisItem.toUpperCase().contains("NOW")) {
                this.plugin.getCommandRegistry().getCommand(EngageCommand.class).setEngaged(theDenizen, true);
            }
            String[] scriptEntry = new String[2];
            if (thisItem.split(" ", 2).length == 1) {
                scriptEntry[0] = thisItem;
                scriptEntry[1] = null;
            } else {
                scriptEntry = thisItem.split(" ", 2);
            }
            try {
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Adding '" + scriptEntry[0] + "' command.");
                }
                scriptCommands.add(new ScriptEntry(scriptEntry[0], this.buildArgs(thePlayer, theDenizen, scriptEntry[1]), thePlayer, theDenizen, theScriptName, theStep, playerMessage, theText));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }

    public void queueScriptEntries(Player thePlayer, List<ScriptEntry> scriptEntries, ScriptEngine.QueueType queueType) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Queueing script to Player Queues:");
        }
        if (scriptEntries == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return;
        }
        if (scriptEntries.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return;
        }
        Map<Player, List<ScriptEntry>> thisQueue = this.plugin.getScriptEngine().getQueue(queueType);
        ArrayList<ScriptEntry> existingScriptEntries = new ArrayList<ScriptEntry>();
        if (thisQueue.containsKey(thePlayer)) {
            existingScriptEntries.addAll((Collection)thisQueue.get(thePlayer));
        }
        thisQueue.remove(thePlayer);
        if (!scriptEntries.isEmpty()) {
            existingScriptEntries.addAll(scriptEntries);
        } else {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
        }
        thisQueue.put(thePlayer, existingScriptEntries);
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY!");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
        }
    }

    public void queueScriptEntries(DenizenNPC theDenizen, List<ScriptEntry> scriptEntries, ScriptEngine.QueueType queueType) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Queueing script to Denizen Queue:");
        }
        if (scriptEntries == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return;
        }
        if (scriptEntries.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
            return;
        }
        Map<DenizenNPC, List<ScriptEntry>> thisQueue = this.plugin.getScriptEngine().getDQueue(queueType);
        ArrayList<ScriptEntry> existingScriptEntries = new ArrayList<ScriptEntry>();
        if (thisQueue.containsKey(theDenizen)) {
            existingScriptEntries.addAll((Collection)thisQueue.get(theDenizen));
        }
        thisQueue.remove(theDenizen);
        if (!scriptEntries.isEmpty()) {
            existingScriptEntries.addAll(scriptEntries);
        } else {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "No entries to queue!");
            }
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
        }
        thisQueue.put(theDenizen, existingScriptEntries);
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY!");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
        }
    }

    public List<ScriptEntry> buildScriptEntries(DenizenNPC theDenizen, List<String> theScript, String theScriptName) {
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| ");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Building the script:");
        }
        if (theScript == null) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        if (theScript.isEmpty()) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "...no entries to build!");
            }
            return null;
        }
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        for (String thisItem : theScript) {
            if (thisItem.toUpperCase().contains("ENGAGE") && thisItem.toUpperCase().contains("NOW")) {
                this.plugin.getCommandRegistry().getCommand(EngageCommand.class).setEngaged(theDenizen, true);
            }
            String[] scriptEntry = new String[2];
            if (thisItem.split(" ", 2).length == 1) {
                scriptEntry[0] = thisItem;
                scriptEntry[1] = null;
            } else {
                scriptEntry = thisItem.split(" ", 2);
            }
            try {
                if (this.plugin.getCommandRegistry().getCommand((String)scriptEntry[0]).activityQueueCompatible) {
                    if (this.plugin.debugMode.booleanValue()) {
                        this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Adding '" + scriptEntry[0] + "' command for " + theDenizen.getName() + ".");
                    }
                    scriptCommands.add(new ScriptEntry(scriptEntry[0], this.buildArgs(null, theDenizen, scriptEntry[1]), theDenizen, theScriptName));
                    continue;
                }
                if (!this.plugin.debugMode.booleanValue()) continue;
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "'" + scriptEntry[0] + "' command is not compatible with the Activity Queue.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }

    public void ConcatenateScripts() throws IOException {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.plugin.getDataFolder() + File.separator + "read-only-scripts.yml"));
            File file = new File(this.plugin.getDataFolder() + File.separator + "scripts");
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (!fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("YML") || fileName.startsWith(".")) continue;
                this.plugin.getLogger().log(Level.INFO, "Processing script " + files[i].getName() + "... ");
                BufferedReader br = new BufferedReader(new FileReader(files[i].getPath()));
                String line = br.readLine();
                while (line != null) {
                    pw.println(line);
                    line = br.readLine();
                }
                br.close();
            }
            pw.close();
            this.plugin.getLogger().log(Level.INFO, "OK! All scripts loaded!");
        }
        catch (Throwable error) {
            this.plugin.getLogger().log(Level.WARNING, "Woah! No scripts in /plugins/Denizen/scripts/ to load!");
        }
    }
}

