/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers;

import java.rmi.activation.ActivationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.aufdemrand.denizen.triggers.core.ChatTrigger;
import net.aufdemrand.denizen.triggers.core.ClickTrigger;
import net.aufdemrand.denizen.triggers.core.DamageTrigger;
import net.aufdemrand.denizen.triggers.core.LocationTrigger;
import net.aufdemrand.denizen.triggers.core.PlayerdeathTrigger;
import net.aufdemrand.denizen.triggers.core.ProximityTrigger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TriggerRegistry {
    private Map<String, AbstractTrigger> triggers = new HashMap<String, AbstractTrigger>();
    private Map<Class<? extends AbstractTrigger>, String> triggersClass = new HashMap<Class<? extends AbstractTrigger>, String>();
    public Denizen plugin;

    public TriggerRegistry(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean registerTrigger(String triggerName, AbstractTrigger triggerClass) {
        this.triggers.put(triggerName.toUpperCase(), triggerClass);
        this.triggersClass.put(triggerClass.getClass(), triggerName.toUpperCase());
        triggerClass.triggerName = triggerName.substring(0, 1).toUpperCase() + triggerName.substring(1).toLowerCase();
        this.plugin.getLogger().log(Level.INFO, "Loaded " + triggerClass.triggerName + " Trigger successfully!");
        return true;
    }

    public Map<String, AbstractTrigger> listTriggers() {
        if (this.plugin.debugMode.booleanValue()) {
            this.plugin.getLogger().log(Level.INFO, "Contents of TriggerList: " + this.triggers.keySet().toString());
        }
        return this.triggers;
    }

    public AbstractTrigger getTrigger(String triggerName) {
        if (this.triggers.containsKey(triggerName.toUpperCase())) {
            return this.triggers.get(triggerName.toUpperCase());
        }
        return null;
    }

    public <T extends AbstractTrigger> T getTrigger(Class<T> theClass) {
        if (this.triggersClass.containsKey(theClass)) {
            return (T)((AbstractTrigger)theClass.cast(this.triggers.get(this.triggersClass.get(theClass))));
        }
        return null;
    }

    public void registerCoreTriggers() {
        LocationTrigger locationTrigger = new LocationTrigger();
        ChatTrigger chatTrigger = new ChatTrigger();
        ClickTrigger clickTrigger = new ClickTrigger();
        DamageTrigger damageTrigger = new DamageTrigger();
        ProximityTrigger proximityTrigger = new ProximityTrigger();
        PlayerdeathTrigger playerdeathTrigger = new PlayerdeathTrigger();
        try {
            locationTrigger.activateAs("Location");
            locationTrigger.setEnabledByDefault(false);
            playerdeathTrigger.activateAs("Playerdeath");
            playerdeathTrigger.setEnabledByDefault(false);
            chatTrigger.activateAs("Chat");
            chatTrigger.setEnabledByDefault(true);
            clickTrigger.activateAs("Click");
            clickTrigger.setEnabledByDefault(true);
            damageTrigger.activateAs("Damage");
            proximityTrigger.activateAs("Proximity");
            proximityTrigger.setEnabledByDefault(false);
        }
        catch (ActivationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Oh no! Denizen has run into a problem registering the core triggers!");
            e.printStackTrace();
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)locationTrigger, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)chatTrigger, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)clickTrigger, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)damageTrigger, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)proximityTrigger, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)playerdeathTrigger, (Plugin)this.plugin);
    }
}

