/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    CommandSender cs;

    @EventHandler
    public void chatTrigger(PlayerChatEvent event) {
        DenizenNPC theDenizen = this.plugin.getDenizenNPCRegistry().getClosest(event.getPlayer(), this.plugin.settings.PlayerToNpcChatRangeInBlocks());
        if (theDenizen == null) {
            return;
        }
        if (!theDenizen.hasTrigger(this.triggerName)) {
            return;
        }
        this.echoDebug("Found nearby NPC, interrupting chat...", this.triggerName);
        if (!theDenizen.isInteractable(this.triggerName, event.getPlayer())) {
            if (!this.plugin.settings.ChatGloballyIfNotInteractable()) {
                event.setCancelled(true);
                this.plugin.getSpeechEngine().talkToDenizen(theDenizen, event.getPlayer(), event.getMessage());
                theDenizen.talk(SpeechEngine.TalkType.CHAT_PLAYERONLY, event.getPlayer(), SpeechEngine.Reason.DenizenIsUnavailable);
                return;
            }
            this.echoDebug("Not interactable, resuming chat...", this.triggerName);
            return;
        }
        String theScript = theDenizen.getInteractScript(event.getPlayer(), this.getClass());
        if (theScript == null) {
            if (this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Quick Scripts.Chat Trigger.Script")) {
                List theScript1;
                event.setCancelled(true);
                this.plugin.getSpeechEngine().talkToDenizen(theDenizen, event.getPlayer(), event.getMessage());
                if (this.cs == null) {
                    this.cs = Bukkit.getConsoleSender();
                }
                if (this.plugin.debugMode.booleanValue()) {
                    this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing QUICK CHAT script: " + theDenizen.getName() + "/" + event.getPlayer().getName() + " -+");
                }
                if ((theScript1 = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Quick Scripts.Chat Trigger.Script")).isEmpty()) {
                    theDenizen.talk(SpeechEngine.TalkType.CHAT, event.getPlayer(), SpeechEngine.Reason.NoMatchingChatTriggers);
                    return;
                }
                ScriptHelper sE = this.plugin.getScriptEngine().helper;
                sE.queueScriptEntries(event.getPlayer(), sE.buildScriptEntries(event.getPlayer(), theDenizen, theScript1, theDenizen.getName() + " Quick Chat", 1), ScriptEngine.QueueType.TASK);
                return;
            }
            if (!this.plugin.settings.ChatGloballyIfNoChatTriggers()) {
                event.setCancelled(true);
                this.plugin.getSpeechEngine().talkToDenizen(theDenizen, event.getPlayer(), event.getMessage());
                theDenizen.talk(SpeechEngine.TalkType.CHAT, event.getPlayer(), SpeechEngine.Reason.NoMatchingChatTriggers);
                return;
            }
            this.echoDebug("No script, resuming chat...", this.triggerName);
            return;
        }
        if (this.parseChatScript(theDenizen, event.getPlayer(), theScript, event.getMessage())) {
            event.setCancelled(true);
            return;
        }
        ConsoleCommandSender cs = Bukkit.getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + "No matching chat trigger.");
        }
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
        }
        if (!this.plugin.settings.ChatGloballyIfFailedChatTriggers()) {
            this.plugin.getSpeechEngine().talkToDenizen(theDenizen, event.getPlayer(), event.getMessage());
            theDenizen.talk(SpeechEngine.TalkType.CHAT, event.getPlayer(), SpeechEngine.Reason.NoMatchingChatTriggers);
            event.setCancelled(true);
            return;
        }
        this.echoDebug("No matching triggers in script, resuming chat...", this.triggerName);
    }

    public boolean parseChatScript(DenizenNPC theDenizen, Player thePlayer, String theScriptName, String playerMessage) {
        List<String> theScript;
        boolean letsProceed;
        String chatText;
        String chatTriggers;
        int x;
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        ConsoleCommandSender cs = Bukkit.getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing chat trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step:");
        }
        Integer theStep = sE.getCurrentStep(thePlayer, theScriptName);
        List<String> ChatTriggerList = this.getChatTriggers(theScriptName, theStep);
        for (x = 0; x < ChatTriggerList.size(); ++x) {
            chatTriggers = ChatTriggerList.get(x).replace("<PLAYER>", thePlayer.getName()).replace("<DISPLAYNAME>", ChatColor.stripColor((String)thePlayer.getDisplayName())).toLowerCase();
            chatText = this.plugin.getScripts().getString(theScriptName + ".Steps." + theStep + ".Chat Trigger." + String.valueOf(x + 1) + ".Trigger").replace("/", "");
            letsProceed = false;
            for (String chatTrigger : chatTriggers.split(":")) {
                if (!playerMessage.toLowerCase().contains(chatTrigger)) continue;
                letsProceed = true;
            }
            if (!letsProceed) continue;
            theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep, this.triggerName) + String.valueOf(x + 1) + sE.scriptString);
            if (theScript.isEmpty()) {
                return false;
            }
            this.plugin.getSpeechEngine().talkToDenizen(theDenizen, thePlayer, chatText);
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep, playerMessage, chatText), ScriptEngine.QueueType.TRIGGER);
            return true;
        }
        for (x = 0; x < ChatTriggerList.size(); ++x) {
            chatTriggers = ChatTriggerList.get(x).replace("<PLAYER>", thePlayer.getName()).replace("<DISPLAYNAME>", ChatColor.stripColor((String)thePlayer.getDisplayName())).toLowerCase();
            chatText = this.plugin.getScripts().getString(theScriptName + ".Steps." + theStep + ".Chat Trigger." + String.valueOf(x + 1) + ".Trigger").replace("/", "");
            letsProceed = false;
            for (String chatTrigger : chatTriggers.split(":")) {
                if (!chatTrigger.contains("*")) continue;
                chatText = chatText.replace("*", playerMessage);
                letsProceed = true;
            }
            if (!letsProceed) continue;
            theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep, this.triggerName) + String.valueOf(x + 1) + sE.scriptString);
            if (theScript.isEmpty()) {
                return false;
            }
            this.plugin.getSpeechEngine().talkToDenizen(theDenizen, thePlayer, chatText);
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep, playerMessage, chatText), ScriptEngine.QueueType.TRIGGER);
            return true;
        }
        return false;
    }

    public List<String> getChatTriggers(String theScript, Integer currentStep) {
        ArrayList<String> ChatTriggers = new ArrayList<String>();
        int currentTrigger = 1;
        int x = 1;
        while (currentTrigger >= 0) {
            String theChatTrigger = this.plugin.getScripts().getString(theScript + ".Steps." + currentStep + ".Chat Trigger." + String.valueOf(currentTrigger) + ".Trigger");
            if (theChatTrigger != null) {
                boolean isTrigger = false;
                String triggerBuilder = "";
                for (String trigger : theChatTrigger.split("/")) {
                    if (isTrigger) {
                        triggerBuilder = triggerBuilder + trigger + ":";
                        isTrigger = false;
                        continue;
                    }
                    isTrigger = true;
                }
                triggerBuilder = triggerBuilder.substring(0, triggerBuilder.length() - 1);
                ConsoleCommandSender cs = Bukkit.getConsoleSender();
                if (this.plugin.debugMode.booleanValue()) {
                    cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Found chat trigger: " + triggerBuilder);
                }
                ChatTriggers.add(triggerBuilder);
                currentTrigger = x + 1;
            } else {
                currentTrigger = -1;
            }
            ++x;
        }
        return ChatTriggers;
    }
}

