/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers.core;

import java.util.List;
import java.util.logging.Level;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    CommandSender cs;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void clickTrigger(NPCRightClickEvent event) {
        if (!this.plugin.getDenizenNPCRegistry().isDenizenNPC(event.getNPC())) {
            return;
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        DenizenNPC theDenizen = this.plugin.getDenizenNPCRegistry().getDenizen(event.getNPC());
        if (event.getClicker().isSneaking() && event.getClicker().isOp() && this.plugin.settings.RightClickAndSneakInfoModeEnabled()) {
            theDenizen.showInfo(event.getClicker());
            return;
        }
        if (!theDenizen.hasTrigger(this.triggerName)) {
            if (this.plugin.debugMode.booleanValue()) {
                this.plugin.getLogger().log(Level.INFO, "...click trigger not enabled for this Denizen.");
            }
            return;
        }
        if (!theDenizen.isInteractable(this.triggerName, event.getClicker())) {
            theDenizen.talk(SpeechEngine.TalkType.CHAT_PLAYERONLY, event.getClicker(), SpeechEngine.Reason.DenizenIsUnavailable);
            return;
        }
        sE.setCooldown(theDenizen, ClickTrigger.class, this.plugin.settings.DefaultClickCooldown());
        if (!this.parseClickTrigger(theDenizen, event.getClicker())) {
            theDenizen.talk(SpeechEngine.TalkType.CHAT_PLAYERONLY, event.getClicker(), SpeechEngine.Reason.NoMatchingClickTrigger);
            return;
        }
    }

    public boolean parseClickTrigger(DenizenNPC theDenizen, Player thePlayer) {
        Integer theStep;
        List<String> theScript;
        if (this.cs == null) {
            this.cs = Bukkit.getConsoleSender();
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        String theScriptName = theDenizen.getInteractScript(thePlayer, this.getClass());
        if (theScriptName == null && this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Quick Scripts.Click Trigger.Script")) {
            List theScript2;
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing QUICK CLICK script: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
            }
            if ((theScript2 = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Quick Scripts.Click Trigger.Script")).isEmpty()) {
                return false;
            }
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript2, theDenizen.getName() + " Quick Click", 1), ScriptEngine.QueueType.TASK);
            return true;
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing click trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step:");
        }
        if ((theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep = Integer.valueOf(sE.getCurrentStep(thePlayer, theScriptName)), this.triggerName) + sE.scriptString)).isEmpty()) {
            return false;
        }
        sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.TRIGGER);
        return true;
    }
}

