/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers.core;

import java.util.List;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.aufdemrand.denizen.triggers.core.ClickTrigger;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DamageTrigger
extends AbstractTrigger
implements Listener {
    CommandSender cs;

    @EventHandler(priority=EventPriority.LOWEST)
    public void damageTrigger(EntityDamageByEntityEvent event) {
        Player thePlayer = null;
        if (event.getDamager() instanceof Player) {
            thePlayer = (Player)event.getDamager();
        }
        if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
            thePlayer = (Player)((Projectile)event.getDamager()).getShooter();
        }
        if (CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && thePlayer != null) {
            NPC theNPC = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
            if (this.plugin.getDenizenNPCRegistry().isDenizenNPC(theNPC)) {
                ScriptHelper sE = this.plugin.getScriptEngine().helper;
                DenizenNPC denizenNPC = this.plugin.getDenizenNPCRegistry().getDenizen(theNPC);
                if (((DenizenTrait)denizenNPC.getCitizensEntity().getTrait(DenizenTrait.class)).triggerIsEnabled(this.triggerName.toUpperCase())) {
                    if (denizenNPC.isInteractable(this.triggerName, thePlayer)) {
                        sE.setCooldown(denizenNPC, DamageTrigger.class, this.plugin.settings.DefaultDamageCooldown());
                        if (!this.parseDamageTrigger(denizenNPC, thePlayer)) {
                            denizenNPC.talk(SpeechEngine.TalkType.CHAT, thePlayer, SpeechEngine.Reason.NoMatchingDamageTrigger);
                        }
                    }
                } else if (this.plugin.settings.DisabledDamageTriggerInsteadTriggersClick()) {
                    this.plugin.getTriggerRegistry().getTrigger(ClickTrigger.class).clickTrigger(new NPCRightClickEvent(theNPC, thePlayer));
                }
            }
        }
    }

    public boolean parseDamageTrigger(DenizenNPC theDenizen, Player thePlayer) {
        Integer theStep;
        List<String> theScript;
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        if (this.cs == null) {
            this.cs = Bukkit.getConsoleSender();
        }
        theDenizen.getEntity().playEffect(EntityEffect.HURT);
        String theScriptName = theDenizen.getInteractScript(thePlayer, this.getClass());
        if (theScriptName == null && this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Quick Scripts.Damage Trigger.Script")) {
            List theScript2;
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing QUICK DAMAGE script: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
            }
            if ((theScript2 = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Quick Scripts.Damage Trigger.Script")).isEmpty()) {
                return false;
            }
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript2, theDenizen.getName() + " Quick Damage", 1), ScriptEngine.QueueType.TASK);
            return true;
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing damage trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step:");
        }
        if ((theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep = Integer.valueOf(sE.getCurrentStep(thePlayer, theScriptName)), this.triggerName) + sE.scriptString)).isEmpty()) {
            return false;
        }
        sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.TRIGGER);
        return true;
    }
}

