/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class LocationTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void locationTrigger(PlayerMoveEvent event) {
        if (event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            return;
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        if (!this.plugin.bookmarks.getLocationTriggerList().isEmpty()) {
            boolean hasLocation = false;
            for (Location theLocation : this.plugin.bookmarks.getLocationTriggerList().keySet()) {
                if (!this.plugin.bookmarks.checkLocation(event.getPlayer(), theLocation, this.plugin.settings.LocationTriggerRangeInBlocks())) continue;
                hasLocation = true;
                DenizenNPC theDenizen = null;
                String locationTriggered = this.plugin.bookmarks.getLocationTriggerList().get(theLocation).split(":")[2];
                if (this.plugin.debugMode.booleanValue()) {
                    this.plugin.getLogger().info("[Location Trigger] '" + event.getPlayer().getName() + "' just walked over bookmark '" + locationTriggered + "'");
                }
                if (this.plugin.bookmarks.getLocationTriggerList().get(theLocation).contains("ID:")) {
                    theDenizen = this.plugin.getDenizenNPCRegistry().getDenizen(CitizensAPI.getNPCRegistry().getById(Integer.valueOf(this.plugin.bookmarks.getLocationTriggerList().get(theLocation).split(":")[1]).intValue()));
                } else if (this.plugin.bookmarks.getLocationTriggerList().get(theLocation).contains("NAME:")) {
                    ArrayList<DenizenNPC> denizenList = new ArrayList<DenizenNPC>();
                    for (DenizenNPC npc : this.plugin.getDenizenNPCRegistry().getDenizens().values()) {
                        if (!npc.getName().equals(this.plugin.bookmarks.getLocationTriggerList().get(theLocation).split(":")[1])) continue;
                        denizenList.add(npc);
                        theDenizen = npc;
                    }
                    for (DenizenNPC npc : denizenList) {
                        if (npc.getEntity() == null || !npc.isSpawned() || npc.getWorld() != event.getPlayer().getWorld()) continue;
                        try {
                            if (theDenizen == null) {
                                theDenizen = npc;
                                continue;
                            }
                            if (!(npc.getEntity().getLocation().distance(event.getPlayer().getLocation()) < theDenizen.getEntity().getLocation().distance(event.getPlayer().getLocation()))) continue;
                            theDenizen = npc;
                        }
                        catch (Exception e) {}
                    }
                }
                if (theDenizen == null) {
                    return;
                }
                if (!((DenizenTrait)theDenizen.getCitizensEntity().getTrait(DenizenTrait.class)).triggerIsEnabled("location")) continue;
                if (event.getPlayer().hasMetadata("locationtrigger")) {
                    if (locationTriggered.equals(((MetadataValue)event.getPlayer().getMetadata("locationtrigger").get(0)).asString())) {
                        return;
                    }
                    event.getPlayer().setMetadata("locationtrigger", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)locationTriggered));
                    if (this.plugin.debugMode.booleanValue()) {
                        this.plugin.getLogger().log(Level.INFO, "...location metadata now: '" + ((MetadataValue)event.getPlayer().getMetadata("locationtrigger").get(0)).asString() + "'");
                    }
                    if (!theDenizen.isInteractable(this.triggerName, event.getPlayer())) continue;
                    sE.setCooldown(theDenizen, LocationTrigger.class, this.plugin.settings.DefaultLocationCooldown());
                    this.parseLocationTrigger(theDenizen, event.getPlayer(), locationTriggered);
                    continue;
                }
                event.getPlayer().setMetadata("locationtrigger", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)locationTriggered));
                if (this.plugin.debugMode.booleanValue()) {
                    this.plugin.getLogger().log(Level.INFO, "...location metadata was empty, now: " + ((MetadataValue)event.getPlayer().getMetadata("locationtrigger").get(0)).asString() + "'");
                }
                if (!theDenizen.isInteractable(this.triggerName, event.getPlayer())) continue;
                sE.setCooldown(theDenizen, LocationTrigger.class, this.plugin.settings.DefaultLocationCooldown());
                this.parseLocationTrigger(theDenizen, event.getPlayer(), locationTriggered);
            }
            if (!hasLocation && event.getPlayer().hasMetadata("locationtrigger")) {
                event.getPlayer().removeMetadata("locationtrigger", (Plugin)this.plugin);
            }
        }
    }

    private void parseLocationTrigger(DenizenNPC theDenizen, Player thePlayer, String theLocationName) {
        if (this.plugin.debugMode.booleanValue()) {
            this.plugin.getLogger().log(Level.INFO, "Parsing Location Trigger.");
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        String theScriptName = theDenizen.getInteractScript(thePlayer, this.getClass());
        if (theScriptName == null) {
            return;
        }
        ConsoleCommandSender cs = Bukkit.getConsoleSender();
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing location trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step for '" + theScriptName + "':");
        }
        Integer theStep = sE.getCurrentStep(thePlayer, theScriptName);
        boolean foundScript = false;
        boolean noMatch = true;
        int x = 1;
        if (this.plugin.debugMode.booleanValue()) {
            cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "INFO: Trying to match Location: " + theLocationName);
        }
        do {
            foundScript = true;
            if (!this.plugin.getScripts().contains(sE.getTriggerPath(theScriptName, theStep, this.triggerName) + x + ".Trigger")) continue;
            if (this.plugin.getScripts().getString(sE.getTriggerPath(theScriptName, theStep, this.triggerName) + x + ".Trigger").equals(theLocationName)) {
                noMatch = false;
                if (!this.plugin.debugMode.booleanValue()) continue;
                cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + "Found location in the script.");
                continue;
            }
            foundScript = false;
            ++x;
        } while (!foundScript);
        if (!noMatch) {
            List<String> theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep, this.triggerName) + x + sE.scriptString);
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.TRIGGER);
        } else {
            if (this.plugin.debugMode.booleanValue()) {
                cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + "No matching Triggers found for this Location. Check spacing in your script, or maybe you have spelled something wrong?");
            }
            if (this.plugin.debugMode.booleanValue()) {
                String locationbookmarks = "Available triggers on this NPC: ";
                boolean hasbookmark = false;
                for (String triggerlistitem : this.plugin.bookmarks.getLocationTriggerList().values()) {
                    hasbookmark = true;
                    if (!triggerlistitem.contains(theDenizen.getName())) continue;
                    locationbookmarks = locationbookmarks + triggerlistitem.split(":")[2] + ", ";
                }
                locationbookmarks = !hasbookmark ? locationbookmarks + "NONE!" : locationbookmarks.substring(0, locationbookmarks.length() - 2);
                cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + locationbookmarks);
            }
            if (this.plugin.debugMode.booleanValue()) {
                cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
            }
        }
    }
}

