/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.triggers.core;

import java.util.List;
import java.util.logging.Level;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.triggers.AbstractTrigger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    CommandSender cs;

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            ScriptHelper sE = this.plugin.getScriptEngine().helper;
            if (this.plugin.getDenizenNPCRegistry().getClosest(event.getPlayer(), this.plugin.settings.ProximityTriggerRangeInBlocks()) != null) {
                DenizenNPC theDenizen = this.plugin.getDenizenNPCRegistry().getClosest(event.getPlayer(), this.plugin.settings.ProximityTriggerRangeInBlocks());
                if (((DenizenTrait)theDenizen.getCitizensEntity().getTrait(DenizenTrait.class)).triggerIsEnabled("proximity")) {
                    if (event.getPlayer().hasMetadata("proximity")) {
                        if (((MetadataValue)event.getPlayer().getMetadata("proximity").get(0)).asString().equals(theDenizen.toString()) && this.plugin.debugMode.booleanValue()) {
                            if (!event.getPlayer().hasMetadata("proximitydebug")) {
                                event.getPlayer().setMetadata("proximitydebug", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                                return;
                            }
                            return;
                        }
                        event.getPlayer().setMetadata("proximity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)theDenizen.toString()));
                        if (this.plugin.debugMode.booleanValue()) {
                            this.plugin.getLogger().log(Level.INFO, "...proximity metadata now: '" + ((MetadataValue)event.getPlayer().getMetadata("proximity").get(0)).asString() + "'");
                        }
                        if (theDenizen.isInteractable(this.triggerName, event.getPlayer())) {
                            sE.setCooldown(theDenizen, ProximityTrigger.class, this.plugin.settings.DefaultProximityCooldown());
                            this.parseProximityTrigger(theDenizen, event.getPlayer());
                        }
                    } else if (theDenizen.isInteractable(this.triggerName, event.getPlayer())) {
                        event.getPlayer().setMetadata("proximity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)theDenizen.toString()));
                        if (this.plugin.debugMode.booleanValue()) {
                            this.plugin.getLogger().log(Level.INFO, "...proximity metadata was empty, now: " + ((MetadataValue)event.getPlayer().getMetadata("proximity").get(0)).asString() + "'");
                        }
                        sE.setCooldown(theDenizen, ProximityTrigger.class, this.plugin.settings.DefaultProximityCooldown());
                        this.parseProximityTrigger(theDenizen, event.getPlayer());
                    }
                }
            } else {
                if (event.getPlayer().hasMetadata("proximity")) {
                    event.getPlayer().removeMetadata("proximity", (Plugin)this.plugin);
                }
                if (this.plugin.debugMode.booleanValue() && event.getPlayer().hasMetadata("proximitydebug")) {
                    event.getPlayer().removeMetadata("proximitydebug", (Plugin)this.plugin);
                }
            }
        }
    }

    public boolean parseProximityTrigger(DenizenNPC theDenizen, Player thePlayer) {
        Integer theStep;
        List<String> theScript;
        if (this.cs == null) {
            this.cs = Bukkit.getConsoleSender();
        }
        ScriptHelper sE = this.plugin.getScriptEngine().helper;
        String theScriptName = theDenizen.getInteractScript(thePlayer, this.getClass());
        if (theScriptName == null && this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Quick Scripts.Proximity Trigger.Script")) {
            List theScript2;
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing QUICK PROXIMITY script: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
            }
            if ((theScript2 = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Quick Scripts.Proximity Trigger.Script")).isEmpty()) {
                return false;
            }
            sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript2, theDenizen.getName() + " Quick Proximity", 1), ScriptEngine.QueueType.TASK);
            return true;
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Parsing proximity trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step:");
        }
        if ((theScript = sE.getScript(sE.getTriggerPath(theScriptName, theStep = Integer.valueOf(sE.getCurrentStep(thePlayer, theScriptName)), this.triggerName) + sE.scriptString)).isEmpty()) {
            return false;
        }
        sE.queueScriptEntries(thePlayer, sE.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.TRIGGER);
        return true;
    }
}

