/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.List;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class GetPlayer {
    private Denizen plugin;

    public GetPlayer(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean checkLevel(Player thePlayer, String theLevel, String highLevel, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (highLevel == null) {
                if (thePlayer.getLevel() >= Integer.valueOf(theLevel)) {
                    outcome = true;
                }
            } else if (highLevel != null && thePlayer.getLevel() >= Integer.valueOf(theLevel) && thePlayer.getLevel() <= Integer.valueOf(highLevel)) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured with a LEVEL requirement.");
            Bukkit.getLogger().info("Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkSaturation(Player thePlayer, String saturationType, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (saturationType.equalsIgnoreCase("STARVING") && thePlayer.getFoodLevel() <= 2) {
                outcome = true;
            }
            if (saturationType.equalsIgnoreCase("HUNGRY") && thePlayer.getFoodLevel() <= 18) {
                outcome = true;
            }
            if (saturationType.equalsIgnoreCase("FULL") && thePlayer.getFoodLevel() >= 18) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkName(Player thePlayer, List<String> theNames, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (theNames.contains(thePlayer.getName().toUpperCase())) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkFunds(Player thePlayer, String theFunds, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (this.plugin.economy.has(thePlayer.getName(), Double.parseDouble(theFunds))) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkInventory(Player thePlayer, String theItem, String theData, String theAmount, boolean negativeRequirement) {
        boolean outcome = false;
        if (theAmount == null) {
            theAmount = "1";
        }
        try {
            if (Character.isDigit(theItem.charAt(0))) {
                if (theData == null) {
                    theData = "0";
                }
                String friendlyItem = theItem + ":" + theData;
                if (this.plugin.utilities.getInventoryIdMap(thePlayer).containsKey(friendlyItem) && this.plugin.utilities.getInventoryIdMap(thePlayer).get(friendlyItem) >= Integer.valueOf(theAmount)) {
                    outcome = true;
                }
            } else if (this.plugin.utilities.getInventoryMap(thePlayer).containsKey(Material.valueOf((String)theItem)) && this.plugin.utilities.getInventoryMap(thePlayer).get(Material.valueOf((String)theItem)) >= Integer.valueOf(theAmount)) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkHand(Player thePlayer, String theItem, String theData, String theAmount, boolean negativeRequirement) {
        boolean outcome = false;
        if (theAmount == null) {
            theAmount = "1";
        }
        try {
            if (Character.isDigit(theItem.charAt(0))) {
                if (theData == null) {
                    if (thePlayer.getItemInHand().getTypeId() == Integer.valueOf(theItem).intValue() && thePlayer.getItemInHand().getAmount() >= Integer.valueOf(theAmount)) {
                        outcome = true;
                    }
                } else if (thePlayer.getItemInHand().getTypeId() == Integer.valueOf(theItem).intValue() && thePlayer.getItemInHand().getAmount() >= Integer.valueOf(theAmount) && thePlayer.getItemInHand().getData().getData() == (byte)Integer.parseInt(theData)) {
                    outcome = true;
                }
            } else if (thePlayer.getItemInHand().getType() == Material.valueOf((String)theItem) && thePlayer.getItemInHand().getAmount() >= Integer.valueOf(theAmount)) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured with a HOLDING requirement.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkDurability(Player thePlayer, String operator, String theAmount, boolean negativeRequirement) {
        boolean outcome = false;
        if (operator == null || theAmount == null) {
            throw new IllegalArgumentException("DURABILITY requires 2 arguments, an operator (>,<, or =) followed by a number or percentage.");
        }
        if (!(">".equals(operator) || "<".equals(operator) || "=".equals(operator))) {
            throw new IllegalArgumentException("DURABILITY requires that the first argument should be >, <, or =.");
        }
        if (!Pattern.matches("[0-9]{1,}|[0-9]{1,3}%", theAmount)) {
            throw new IllegalArgumentException("DURABILITY requires that the second argument should be a number (123), or a percentage (55%).");
        }
        short max = thePlayer.getItemInHand().getType().getMaxDurability();
        short currentDurability = (short)(max - thePlayer.getItemInHand().getDurability());
        short amount = -1;
        if (theAmount.endsWith("%")) {
            float percent = Float.parseFloat(theAmount.substring(0, theAmount.length() - 1)) / 100.0f;
            amount = (short)Math.round((float)max * percent);
        } else {
            amount = Short.parseShort(theAmount);
        }
        if (">".equals(operator)) {
            outcome = currentDurability > amount;
        } else if ("<".equals(operator)) {
            outcome = currentDurability < amount;
        } else if ("=".equals(operator)) {
            boolean bl = outcome = currentDurability == amount;
        }
        if (negativeRequirement) {
            outcome = !outcome;
        }
        return outcome;
    }

    public boolean checkArmor(Player thePlayer, String theArmor, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            ItemStack[] ArmorContents = thePlayer.getInventory().getArmorContents();
            if (Character.isDigit(theArmor.charAt(0))) {
                for (ItemStack ArmorPiece : ArmorContents) {
                    if (ArmorPiece == null || ArmorPiece.getTypeId() != Integer.valueOf(theArmor).intValue()) continue;
                    outcome = true;
                }
            } else {
                for (ItemStack ArmorPiece : ArmorContents) {
                    if (ArmorPiece == null || ArmorPiece.getType() != Material.getMaterial((String)theArmor.toUpperCase())) continue;
                    outcome = true;
                }
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured. Check your command syntax.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkEffects(Player thePlayer, List<String> theEffects, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            for (String theEffect : theEffects) {
                if (theEffect == null || !thePlayer.hasPotionEffect(PotionEffectType.getByName((String)theEffect))) continue;
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkPermissions(Player thePlayer, List<String> thePermissions, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            for (String thePermission : thePermissions) {
                if (thePermission == null || !thePlayer.hasPermission(thePermission)) continue;
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured. Check your command syntax.");
            Bukkit.getLogger().info("--- Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkGroups(Player thePlayer, List<String> theGroups, boolean negativeRequirement) {
        boolean outcome = false;
        for (String theGroup : theGroups) {
            if (theGroup == null) continue;
            if (this.plugin.perms.playerInGroup(thePlayer, theGroup)) {
                outcome = true;
            }
            if (this.plugin.perms.playerInGroup((World)null, thePlayer.getName(), theGroup)) {
                outcome = true;
            }
            if (!this.plugin.perms.playerInGroup(thePlayer.getWorld(), thePlayer.getName(), theGroup)) continue;
            outcome = true;
        }
        return negativeRequirement != outcome;
    }
}

