/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;

public class GetWorld {
    private Denizen plugin;

    public GetWorld(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean checkTime(World theWorld, String theTime, String highTime, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (!Character.isDigit(theTime.charAt(0))) {
                if (theTime.equalsIgnoreCase("DAWN") && theWorld.getTime() > 23000L) {
                    outcome = true;
                } else if (theTime.equalsIgnoreCase("DAY") && theWorld.getTime() > 0L && theWorld.getTime() < 13500L) {
                    outcome = true;
                } else if (theTime.equalsIgnoreCase("DUSK") && theWorld.getTime() > 12500L && theWorld.getTime() < 13500L) {
                    outcome = true;
                } else if (theTime.equalsIgnoreCase("NIGHT") && theWorld.getTime() > 13500L) {
                    outcome = true;
                }
            } else if (Character.isDigit(theTime.charAt(0)) && theWorld.getTime() > Long.valueOf(theTime) && theWorld.getTime() < Long.valueOf(highTime)) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured with the TIME requirement.");
            Bukkit.getLogger().info("Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkWeather(World theWorld, String weatherType, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (weatherType.equalsIgnoreCase("PRECIPITATION") && theWorld.hasStorm()) {
                outcome = true;
            } else if (weatherType.equalsIgnoreCase("SUNNY") && !theWorld.hasStorm()) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured with a WEATHER requirement.");
            Bukkit.getLogger().info("Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }

    public boolean checkWorld(LivingEntity theEntity, List<String> theWorlds, boolean negativeRequirement) {
        boolean outcome = false;
        try {
            if (theWorlds.contains(theEntity.getWorld().getName().toUpperCase())) {
                outcome = true;
            }
        }
        catch (Throwable error) {
            Bukkit.getLogger().info("Denizen: An error has occured with the WORLD requirement.");
            Bukkit.getLogger().info("Error follows: " + error);
        }
        return negativeRequirement != outcome;
    }
}

