/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.aufdemrand.denizen.Denizen;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class Utilities {
    private Denizen plugin;

    public Utilities(Denizen plugin) {
        this.plugin = plugin;
    }

    public boolean isEntity(String theString) {
        for (ValidEntities entity : ValidEntities.values()) {
            if (!entity.name().equals(theString.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public String getVersionString() {
        return "Denizen version: " + this.getVersionNumber();
    }

    public Map<Material, Integer> getInventoryMap(Player thePlayer) {
        HashMap<Material, Integer> playerInv = new HashMap<Material, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            if (playerInv.containsKey(getContents.get(x).getType())) {
                int t = (Integer)playerInv.get(getContents.get(x).getType());
                playerInv.put(getContents.get(x).getType(), t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(getContents.get(x).getType(), getContents.get(x).getAmount());
        }
        return playerInv;
    }

    public Map<String, Integer> getInventoryIdMap(Player thePlayer) {
        HashMap<String, Integer> playerInv = new HashMap<String, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            MaterialData specificItem = getContents.get(x).getData();
            String friendlyItem = specificItem.getItemTypeId() + ":" + specificItem.getData();
            if (playerInv.containsKey(friendlyItem)) {
                int t = (Integer)playerInv.get(friendlyItem);
                playerInv.put(friendlyItem, t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(friendlyItem, getContents.get(x).getAmount());
        }
        return playerInv;
    }

    private static enum ValidEntities {
        BLAZE,
        BOAT,
        CAVE_SPIDER,
        CHICKEN,
        COW,
        CREEPER,
        ENDER_DRAGON,
        ENDERMAN,
        GHAST,
        GIANT,
        IRON_GOLEM,
        MAGMA_CUBE,
        MUSHROOM_COW,
        MINECART,
        OCELOT,
        PIG,
        PIG_ZOMBIE,
        PRIMED_TNT,
        SHEEP,
        SILVERFISH,
        SKELETON,
        SLIME,
        SNOWMAN,
        SQUID,
        VILLAGER,
        WOLF,
        ZOMBIE,
        WITCH,
        BAT;

    }
}

