/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEntry {
    private final String command;
    private final Long queueTime;
    private Long allowedRunTime;
    private boolean isInstant = false;
    private Player player = null;
    private OfflinePlayer offlinePlayer = null;
    private String script = null;
    private String step = null;
    private DenizenNPC npc = null;
    private ScriptEngine.QueueType queueType = null;
    private List<String> args = null;
    private Denizen denizen = null;
    private Map<String, Object> objects = new HashMap<String, Object>();

    public ScriptEntry(String command, String[] arguments) throws ScriptEntryCreationException {
        this(command, arguments, null, null, null, null, null, null);
    }

    public ScriptEntry(String command, String[] arguments, Player player) throws ScriptEntryCreationException {
        this(command, arguments, player, null, null, null, null, null);
    }

    public ScriptEntry(String command, String[] arguments, Player player, String script) throws ScriptEntryCreationException {
        this(command, arguments, player, null, script, null, null, null);
    }

    public ScriptEntry(String command, String[] arguments, DenizenNPC denizen, String script) throws ScriptEntryCreationException {
        this(command, arguments, null, denizen, script, null, null, null);
    }

    public ScriptEntry(String command, String[] arguments, Player player, DenizenNPC denizen, String script, String step) throws ScriptEntryCreationException {
        this(command, arguments, player, denizen, script, step, null, null);
    }

    public ScriptEntry(String command, String[] arguments, Player player, DenizenNPC npc, String script, String step, String messageRaw, String messageFormatted) throws ScriptEntryCreationException {
        if (command == null) {
            throw new ScriptEntryCreationException("CommandType cannot be null!");
        }
        if (this.denizen == null) {
            this.denizen = (Denizen)Bukkit.getPluginManager().getPlugin("Denizen");
        }
        this.allowedRunTime = this.queueTime = Long.valueOf(System.currentTimeMillis());
        if (command.startsWith("^")) {
            this.isInstant = true;
            command = command.substring(1);
        }
        this.command = command.toUpperCase();
        this.player = player;
        this.npc = npc;
        this.args = new ArrayList<String>();
        if (arguments != null) {
            this.args = Arrays.asList(arguments);
        }
        this.script = script;
        this.step = step;
    }

    public ScriptEntry addObject(String key, Object object) {
        this.objects.put(key.toUpperCase(), object);
        return this;
    }

    public Long getAllowedRunTime() {
        return this.allowedRunTime;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public String getCommand() {
        return this.command;
    }

    public DenizenNPC getNPC() {
        return this.npc;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key.toUpperCase());
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getScript() {
        if (this.script == null) {
            return this.script;
        }
        return this.script.toUpperCase();
    }

    public ScriptEngine.QueueType getSendingQueue() {
        return this.queueType;
    }

    public String getStep() {
        if (this.step == null) {
            return null;
        }
        return this.step.toUpperCase();
    }

    public Long getQueueTime() {
        return this.queueTime;
    }

    public boolean isInstant() {
        return this.isInstant;
    }

    public ScriptEntry setAllowedRunTime(Long newTime) {
        this.allowedRunTime = newTime;
        return this;
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.isInstant = instant;
        return this;
    }

    public ScriptEntry setOfflinePlayer(OfflinePlayer player) {
        this.offlinePlayer = player;
        return this;
    }

    public ScriptEntry setPlayer(Player player) {
        this.player = player;
        return this;
    }

    public ScriptEntry setNPC(DenizenNPC denizenNPC) {
        this.npc = denizenNPC;
        return this;
    }

    public ScriptEntry setScriptName(String scriptName) {
        this.script = scriptName;
        return this;
    }

    public ScriptEntry setStep(String step) {
        this.step = step;
        return this;
    }

    public void setSendingQueue(ScriptEngine.QueueType queue) {
        this.queueType = queue;
    }
}

