/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Player target = null;
        int duration = 60;
        int amplifier = 1;
        PotionEffectType potion = null;
        if (scriptEntry.getPlayer() != null) {
            target = scriptEntry.getPlayer();
        } else if (scriptEntry.getNPC() != null) {
            target = scriptEntry.getNPC().getEntity();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = Integer.valueOf(arg.split(":")[1]);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (aH.matchesValueArg("POWER", arg, aH.ArgumentType.Integer)) {
                amplifier = aH.getIntegerFrom(arg);
                dB.echoDebug("...set POWER to '%s'.", String.valueOf(amplifier));
                continue;
            }
            if (aH.matchesValueArg("TARGET", arg, aH.ArgumentType.LivingEntity)) {
                if (aH.getStringFrom(arg).equalsIgnoreCase("PLAYER") && scriptEntry.getPlayer() != null) {
                    target = scriptEntry.getPlayer();
                } else if (aH.getStringFrom(arg).equalsIgnoreCase("NPC") && scriptEntry.getNPC() != null) {
                    target = scriptEntry.getNPC().getEntity();
                } else if (aH.getLivingEntityFrom(arg) != null) {
                    target = aH.getLivingEntityFrom(arg);
                } else {
                    dB.echoError("Invalid TARGET type or unavailable TARGET object!");
                    continue;
                }
                dB.echoDebug("...set TARGET to '%s'", aH.getStringFrom(arg));
                continue;
            }
            if (potion == null) {
                try {
                    potion = PotionEffectType.getByName((String)aH.getStringFrom(arg));
                    dB.echoDebug("...set PotionEffectType: '%s'", aH.getStringFrom(arg));
                }
                catch (Exception e) {
                    dB.echoError("Invalid PotionEffectType!");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (potion == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "PotionType");
        }
        if (target == null) {
            throw new InvalidArgumentsException("No target Object! Perhaps you specified a non-existing Player or NPCID?");
        }
        PotionEffect potionEffect = new PotionEffect(potion, duration, amplifier);
        scriptEntry.addObject("potion", potionEffect);
        scriptEntry.addObject("target", target);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        PotionEffect potion = (PotionEffect)scriptEntry.getObject("potion");
        if (!potion.apply((LivingEntity)scriptEntry.getObject("target"))) {
            dB.echoError("Bukkit was unable to apply '" + potion.getType().getName() + "'.");
        }
    }
}

