/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events;

import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ReplaceableTagEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private Player player;
    private DenizenNPC npc;
    private boolean instant = false;
    private boolean wasReplaced = false;
    private String baseContext = null;
    private String name = null;
    private String nameContext = null;
    private String type = null;
    private String typeContext = null;
    private String subType = null;
    private String subTypeContext = null;
    private String value = null;
    private String valueContext = null;
    private String alternative = null;
    private String replaced = null;

    public ReplaceableTagEvent(Player player, DenizenNPC npc, String tag) {
        String inQuestion;
        this.replaced = tag;
        this.player = player;
        this.npc = npc;
        if (tag.startsWith("!") || tag.startsWith("^")) {
            this.instant = true;
            tag = tag.substring(1);
        }
        if (tag.startsWith("[") || tag.startsWith(" [")) {
            this.baseContext = tag.split("\\]", 2)[0].split("\\[", 2)[1].trim();
            dB.log(this.baseContext);
            this.parseContext();
            tag = tag.split("\\]", 2)[1];
        }
        if (tag.contains("||")) {
            this.alternative = tag.split("\\|\\|")[1].trim();
            dB.log(this.alternative);
            tag = tag.split("\\|\\|", 2)[0];
        }
        if (tag.contains(":")) {
            inQuestion = tag.split(":", 2)[1];
            if (inQuestion.contains("[")) {
                this.value = inQuestion.split("\\[", 2)[0].trim();
                this.valueContext = inQuestion.split("\\[", 2)[1].split("\\]", 2)[0].trim();
            } else {
                this.value = inQuestion.trim();
            }
            tag = tag.split(":", 2)[0];
        }
        if (tag.contains(".")) {
            inQuestion = tag.split("\\.", 2)[0];
            if (inQuestion.contains("[")) {
                this.name = inQuestion.split("\\[", 2)[0].trim();
                this.nameContext = inQuestion.split("\\[", 2)[1].split("\\]", 2)[0].trim();
            } else {
                this.name = inQuestion.trim();
            }
            tag = tag.split("\\.", 2)[1];
            if (tag.contains(".")) {
                inQuestion = tag.split("\\.", 2)[0];
                if (inQuestion.contains("[")) {
                    this.type = inQuestion.split("\\[", 2)[0].trim();
                    this.typeContext = inQuestion.split("\\[", 2)[1].split("\\]", 2)[0].trim();
                } else {
                    this.type = inQuestion.trim();
                }
                tag = tag.split("\\.")[1];
                if (tag.contains("[")) {
                    this.subType = inQuestion.split("\\[", 2)[0].trim();
                    this.subTypeContext = inQuestion.split("\\[", 2)[1].split("\\]", 2)[0].trim();
                } else {
                    this.subType = tag.trim();
                }
            } else if (tag.contains("[")) {
                this.type = tag.split("\\[", 2)[0].trim();
                this.typeContext = tag.split("\\[", 2)[1].split("\\]", 2)[0].trim();
            } else {
                this.type = tag.trim();
            }
        } else {
            this.name = tag;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameContext() {
        return this.nameContext;
    }

    public boolean hasNameContext() {
        return this.nameContext != null;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getTypeContext() {
        return this.typeContext;
    }

    public boolean hasTypeContext() {
        return this.typeContext != null;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null;
    }

    public String getSubTypeContext() {
        return this.subTypeContext;
    }

    public boolean hasSubTypeContext() {
        return this.subTypeContext != null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValueContext() {
        return this.valueContext;
    }

    public boolean hasValueContext() {
        return this.valueContext != null;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public boolean hasAlternative() {
        return this.alternative != null;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public DenizenNPC getNPC() {
        return this.npc;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getReplaced() {
        return this.replaced;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public boolean matches(String tagName) {
        return this.name.equalsIgnoreCase(tagName);
    }

    public boolean replaced() {
        return this.wasReplaced;
    }

    public void setReplaced(String string) {
        this.replaced = string;
        this.wasReplaced = true;
    }

    private void parseContext() {
        if (this.baseContext == null || this.baseContext.length() == 1) {
            return;
        }
        for (String context : this.baseContext.split("\\|")) {
            LivingEntity entity = aH.getLivingEntityFrom(context);
            if (entity == null) continue;
            if (CitizensAPI.getNPCRegistry().isNPC((Entity)entity)) {
                this.npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC((Entity)entity));
                continue;
            }
            if (!(entity instanceof Player)) continue;
            this.player = (Player)entity;
        }
    }

    public String toString() {
        return (this.instant ? "Instant=true," : "") + "Player=" + (this.player != null ? this.player.getName() : "null") + ", " + "NPC=" + (this.npc != null ? this.npc.getName() : "null") + ", " + "NAME=" + (this.nameContext != null ? this.name + "(" + this.nameContext + "), " : this.name + ", ") + (this.type != null ? (this.typeContext != null ? "TYPE=" + this.type + "(" + this.typeContext + "), " : "TYPE=" + this.type + ", ") : "") + (this.subType != null ? (this.subTypeContext != null ? "SUBTYPE=" + this.subType + "(" + this.subTypeContext + "), " : "SUBTYPE=" + this.subType + ", ") : "") + (this.value != null ? (this.valueContext != null ? "VALUE=" + this.value + "(" + this.valueContext + "), " : "VALUE=" + this.value + ", ") : "") + (this.alternative != null ? "ALTERNATIVE=" + this.alternative + ", " : "");
    }
}

